package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPipePointMapper;
import com.zehong.system.domain.TPipePoint;
import com.zehong.system.service.ITPipePointService;

import static java.util.stream.Collectors.groupingBy;

/**
 * 管线打卡点Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-15
 */
@Service
public class TPipePointServiceImpl implements ITPipePointService 
{
    @Autowired
    private TPipePointMapper tPipePointMapper;

    /**
     * 查询管线打卡点
     * 
     * @param id 管线打卡点ID
     * @return 管线打卡点
     */
    @Override
    public TPipePoint selectTPipePointById(Long id)
    {
        return tPipePointMapper.selectTPipePointById(id);
    }

    /**
     * 查询管线打卡点列表
     * 
     * @param tPipePoint 管线打卡点
     * @return 管线打卡点
     */
    @Override
    public List<TPipePoint> selectTPipePointList(TPipePoint tPipePoint)
    {
        return tPipePointMapper.selectTPipePointList(tPipePoint);
    }

    /**
     * 新增管线打卡点
     * 
     * @param tPipePoint 管线打卡点
     * @return 结果
     */
    @Override
    public int insertTPipePoint(TPipePoint tPipePoint)
    {
        tPipePoint.setCreateTime(DateUtils.getNowDate());
        tPipePoint.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
        return tPipePointMapper.insertTPipePoint(tPipePoint);
    }

    /**
     * 修改管线打卡点
     * 
     * @param tPipePoint 管线打卡点
     * @return 结果
     */
    @Override
    public int updateTPipePoint(TPipePoint tPipePoint)
    {
        return tPipePointMapper.updateTPipePoint(tPipePoint);
    }

    /**
     * 批量删除管线打卡点
     * 
     * @param ids 需要删除的管线打卡点ID
     * @return 结果
     */
    @Override
    public int deleteTPipePointByIds(Long[] ids)
    {
        return tPipePointMapper.deleteTPipePointByIds(ids);
    }

    /**
     * 删除管线打卡点信息
     * 
     * @param id 管线打卡点ID
     * @return 结果
     */
    @Override
    public int deleteTPipePointById(Long id)
    {
        return tPipePointMapper.deleteTPipePointById(id);
    }

    @Override
    public List<TPipePoint> selectPointDetail(String pipeType){
        List<TPipePoint> pointInfoDetail = new ArrayList<>();
        List<TPipePoint> pointList = tPipePointMapper.selectPointDetail(pipeType);
        Map<Long, Map<Long, List<TPipePoint>>> pointDetail = pointList.stream().collect(groupingBy(TPipePoint::getUserId,groupingBy(TPipePoint::getPipeId)));
        for(Long userId : pointDetail.keySet()){
            TPipePoint userPoint = new TPipePoint();
            List<TPipePoint> pipeDetailList = new ArrayList<>();
            List<TPipePoint> pipePointDetailList = new ArrayList<>();
            Map<Long,List<TPipePoint>> pointMap = pointDetail.get(userId);
            for(long pipeId : pointMap.keySet()){
                TPipePoint pipePoint = new TPipePoint();
                pipePoint.setPipeId(pipeId);
                List<TPipePoint> points = pointMap.get(pipeId);
                pipePoint.setPipeName(points.stream().findAny().get().getPipeName());
                pipePoint.setPipePointList(points);
                pipeDetailList.add(pipePoint);
                pipePointDetailList.addAll(points);
            }
            userPoint.setUserId(userId);
            userPoint.setInspector(pointList.stream().filter(item -> item.getUserId() == userId).findAny().get().getInspector());
            userPoint.setUserPipeInfo(pipeDetailList);
            userPoint.setPipePointList(pipePointDetailList);
            pointInfoDetail.add(userPoint);
        }
        return pointInfoDetail;
    }
}
