package com.zehong.system.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.redis.RedisCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TGasAlarmMapper;
import com.zehong.system.domain.TGasAlarm;
import com.zehong.system.service.ITGasAlarmService;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * 报警器报警记录Service业务层处理
 * 
 * @author zehong
 * @date 2024-09-10
 */
@Service
public class TGasAlarmServiceImpl implements ITGasAlarmService 
{
    @Autowired
    private TGasAlarmMapper tGasAlarmMapper;

    @Autowired
    private RedisCache redisCache;

    /**
     * 查询报警器报警记录
     * 
     * @param id 报警器报警记录ID
     * @return 报警器报警记录
     */
    @Override
    public TGasAlarm selectTGasAlarmById(Long id)
    {
        return tGasAlarmMapper.selectTGasAlarmById(id);
    }

    /**
     * 查询报警器报警记录列表
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 报警器报警记录
     */
    @Override
    public List<TGasAlarm> selectTGasAlarmList(TGasAlarm tGasAlarm)
    {
        return tGasAlarmMapper.selectTGasAlarmList(tGasAlarm);
    }

    /**
     * 新增报警器报警记录
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 结果
     */
    @Override
    public int insertTGasAlarm(TGasAlarm tGasAlarm)
    {
        return tGasAlarmMapper.insertTGasAlarm(tGasAlarm);
    }

    /**
     * 修改报警器报警记录
     * 
     * @param tGasAlarm 报警器报警记录
     * @return 结果
     */
    @Override
    public int updateTGasAlarm(TGasAlarm tGasAlarm)
    {
        if(2 == tGasAlarm.getType()){
            tGasAlarm.setEndtime(new Date());
            tGasAlarm.setStatus(0);
        }
        int i = tGasAlarmMapper.updateTGasAlarm(tGasAlarm);
        if(i >0 && null != tGasAlarm.getReason() && !StringUtils.isEmpty(tGasAlarm.getRemark())){
            //2为安博汇设备特殊处理
            if(2 == tGasAlarm.getType()){
                if(!StringUtils.isEmpty(tGasAlarm.getNumber())){
                    redisCache.redisTemplate.opsForHash().delete("alarm_id",tGasAlarm.getNumber());
                    if(null == redisCache.getCacheMapValue("alarm_id",tGasAlarm.getNumber())){
                        redisCache.redisTemplate.opsForHash().delete("gas_warning",String.valueOf(tGasAlarm.getId()));
                    }
                }

            }else{
                JSONObject alarmInfo = redisCache.getCacheMapValue("gas_warning",String.valueOf(tGasAlarm.getId()));
                if(null != alarmInfo){
                    alarmInfo.put("reason",tGasAlarm.getReason());
                    redisCache.setCacheMapValue("gas_warning",String.valueOf(tGasAlarm.getId()),alarmInfo);
                }
            }
        }
        return i;
    }

    /**
     * 批量删除报警器报警记录
     * 
     * @param ids 需要删除的报警器报警记录ID
     * @return 结果
     */
    @Override
    public int deleteTGasAlarmByIds(Long[] ids)
    {
        return tGasAlarmMapper.deleteTGasAlarmByIds(ids);
    }

    /**
     * 删除报警器报警记录信息
     * 
     * @param id 报警器报警记录ID
     * @return 结果
     */
    @Override
    public int deleteTGasAlarmById(Long id)
    {
        return tGasAlarmMapper.deleteTGasAlarmById(id);
    }

    /**
     * 获取缓存中报警信息
     * @return
     */
    @Override
    public List<JSONObject> getCacheAlarmInfo(){
        Map<String,JSONObject> alarm = redisCache.getCacheMap("gas_warning");
        return alarm.values().stream().filter(item -> "0".equals(item.getString("reason"))).collect(Collectors.toList());
    }
}
