package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDangerInspectTemplateInfoMapper;
import com.zehong.system.domain.TDangerInspectTemplateInfo;
import com.zehong.system.service.ITDangerInspectTemplateInfoService;

/**
 * 隐患日常巡检模版Service业务层处理
 * 
 * @author zehong
 * @date 2024-12-16
 */
@Service
public class TDangerInspectTemplateInfoServiceImpl implements ITDangerInspectTemplateInfoService 
{
    @Autowired
    private TDangerInspectTemplateInfoMapper tDangerInspectTemplateInfoMapper;

    /**
     * 查询隐患日常巡检模版
     * 
     * @param id 隐患日常巡检模版ID
     * @return 隐患日常巡检模版
     */
    @Override
    public TDangerInspectTemplateInfo selectTDangerInspectTemplateInfoById(Long id)
    {
        return tDangerInspectTemplateInfoMapper.selectTDangerInspectTemplateInfoById(id);
    }

    /**
     * 查询隐患日常巡检模版列表
     * 
     * @param tDangerInspectTemplateInfo 隐患日常巡检模版
     * @return 隐患日常巡检模版
     */
    @Override
    public List<TDangerInspectTemplateInfo> selectTDangerInspectTemplateInfoList(TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        return tDangerInspectTemplateInfoMapper.selectTDangerInspectTemplateInfoList(tDangerInspectTemplateInfo);
    }

    /**
     * 新增隐患日常巡检模版
     * 
     * @param tDangerInspectTemplateInfo 隐患日常巡检模版
     * @return 结果
     */
    @Override
    public int insertTDangerInspectTemplateInfo(TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        tDangerInspectTemplateInfo.setCreateTime(DateUtils.getNowDate());
        tDangerInspectTemplateInfo.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserId().toString());
        return tDangerInspectTemplateInfoMapper.insertTDangerInspectTemplateInfo(tDangerInspectTemplateInfo);
    }

    /**
     * 修改隐患日常巡检模版
     * 
     * @param tDangerInspectTemplateInfo 隐患日常巡检模版
     * @return 结果
     */
    @Override
    public int updateTDangerInspectTemplateInfo(TDangerInspectTemplateInfo tDangerInspectTemplateInfo)
    {
        tDangerInspectTemplateInfo.setUpdateTime(DateUtils.getNowDate());
        tDangerInspectTemplateInfo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getUserId().toString());
        return tDangerInspectTemplateInfoMapper.updateTDangerInspectTemplateInfo(tDangerInspectTemplateInfo);
    }

    /**
     * 批量删除隐患日常巡检模版
     * 
     * @param ids 需要删除的隐患日常巡检模版ID
     * @return 结果
     */
    @Override
    public int deleteTDangerInspectTemplateInfoByIds(Long[] ids)
    {
        return tDangerInspectTemplateInfoMapper.deleteTDangerInspectTemplateInfoByIds(ids);
    }

    /**
     * 删除隐患日常巡检模版信息
     * 
     * @param id 隐患日常巡检模版ID
     * @return 结果
     */
    @Override
    public int deleteTDangerInspectTemplateInfoById(Long id)
    {
        return tDangerInspectTemplateInfoMapper.deleteTDangerInspectTemplateInfoById(id);
    }
}
