package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TMemoryLog;

/**
 * 内存报警日志Service接口
 * 
 * @author zehong
 * @date 2024-05-08
 */
public interface ITMemoryLogService 
{
    /**
     * 查询内存报警日志
     * 
     * @param id 内存报警日志ID
     * @return 内存报警日志
     */
    public TMemoryLog selectTMemoryLogById(Long id);

    /**
     * 查询内存报警日志列表
     * 
     * @param tMemoryLog 内存报警日志
     * @return 内存报警日志集合
     */
    public List<TMemoryLog> selectTMemoryLogList(TMemoryLog tMemoryLog);

    /**
     * 新增内存报警日志
     * 
     * @param tMemoryLog 内存报警日志
     * @return 结果
     */
    public int insertTMemoryLog(TMemoryLog tMemoryLog);

    /**
     * 修改内存报警日志
     * 
     * @param tMemoryLog 内存报警日志
     * @return 结果
     */
    public int updateTMemoryLog(TMemoryLog tMemoryLog);

    /**
     * 批量删除内存报警日志
     * 
     * @param ids 需要删除的内存报警日志ID
     * @return 结果
     */
    public int deleteTMemoryLogByIds(Long[] ids);

    /**
     * 删除内存报警日志信息
     * 
     * @param id 内存报警日志ID
     * @return 结果
     */
    public int deleteTMemoryLogById(Long id);
}
