package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDangerStatus;

/**
 * 隐患状态记录Mapper接口
 * 
 * @author zehong
 * @date 2023-12-01
 */
public interface TDangerStatusMapper 
{
    /**
     * 查询隐患状态记录
     * 
     * @param id 隐患状态记录ID
     * @return 隐患状态记录
     */
    public TDangerStatus selectTDangerStatusById(Long id);

    /**
     * 查询隐患状态记录列表
     * 
     * @param tDangerStatus 隐患状态记录
     * @return 隐患状态记录集合
     */
    public List<TDangerStatus> selectTDangerStatusList(TDangerStatus tDangerStatus);

    /**
     * 新增隐患状态记录
     * 
     * @param tDangerStatus 隐患状态记录
     * @return 结果
     */
    public int insertTDangerStatus(TDangerStatus tDangerStatus);

    /**
     * 修改隐患状态记录
     * 
     * @param tDangerStatus 隐患状态记录
     * @return 结果
     */
    public int updateTDangerStatus(TDangerStatus tDangerStatus);

    /**
     * 删除隐患状态记录
     * 
     * @param id 隐患状态记录ID
     * @return 结果
     */
    public int deleteTDangerStatusById(Long id);

    /**
     * 批量删除隐患状态记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDangerStatusByIds(Long[] ids);
}
