package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDangerInspectTemplateInfo;

/**
 * 隐患日常巡检模版Mapper接口
 * 
 * @author zehong
 * @date 2024-12-16
 */
public interface TDangerInspectTemplateInfoMapper 
{
    /**
     * 查询隐患日常巡检模版
     * 
     * @param id 隐患日常巡检模版ID
     * @return 隐患日常巡检模版
     */
    public TDangerInspectTemplateInfo selectTDangerInspectTemplateInfoById(Long id);

    /**
     * 查询隐患日常巡检模版列表
     * 
     * @param tDangerInspectTemplateInfo 隐患日常巡检模版
     * @return 隐患日常巡检模版集合
     */
    public List<TDangerInspectTemplateInfo> selectTDangerInspectTemplateInfoList(TDangerInspectTemplateInfo tDangerInspectTemplateInfo);

    /**
     * 新增隐患日常巡检模版
     * 
     * @param tDangerInspectTemplateInfo 隐患日常巡检模版
     * @return 结果
     */
    public int insertTDangerInspectTemplateInfo(TDangerInspectTemplateInfo tDangerInspectTemplateInfo);

    /**
     * 修改隐患日常巡检模版
     * 
     * @param tDangerInspectTemplateInfo 隐患日常巡检模版
     * @return 结果
     */
    public int updateTDangerInspectTemplateInfo(TDangerInspectTemplateInfo tDangerInspectTemplateInfo);

    /**
     * 删除隐患日常巡检模版
     * 
     * @param id 隐患日常巡检模版ID
     * @return 结果
     */
    public int deleteTDangerInspectTemplateInfoById(Long id);

    /**
     * 批量删除隐患日常巡检模版
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDangerInspectTemplateInfoByIds(Long[] ids);
}
