package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TArea;

/**
 * 地区县镇Mapper接口
 * 
 * @author zehong
 * @date 2023-11-03
 */
public interface TAreaMapper 
{
    /**
     * 查询地区县镇
     * 
     * @param id 地区县镇ID
     * @return 地区县镇
     */
    public TArea selectTAreaById(Long id);

    /**
     * 查询地区县镇列表
     * 
     * @param tArea 地区县镇
     * @return 地区县镇集合
     */
    public List<TArea> selectTAreaList(TArea tArea);

    /**
     * 新增地区县镇
     * 
     * @param tArea 地区县镇
     * @return 结果
     */
    public int insertTArea(TArea tArea);

    /**
     * 修改地区县镇
     * 
     * @param tArea 地区县镇
     * @return 结果
     */
    public int updateTArea(TArea tArea);

    /**
     * 删除地区县镇
     * 
     * @param id 地区县镇ID
     * @return 结果
     */
    public int deleteTAreaById(Long id);

    /**
     * 批量删除地区县镇
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTAreaByIds(Long[] ids);
}
