package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 第三方施工执行对象 t_third_build_inspect
 * 
 * @author zehong
 * @date 2023-12-22
 */
public class TThirdBuildInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 第三方施工id */
    @Excel(name = "第三方施工id")
    private Long thirdBuildId;

    /** 施工情况 */
    @Excel(name = "施工情况")
    private String describe;

    /** 施工图片 */
    @Excel(name = "施工图片")
    private String imgurl;

    /** 监护人员 */
    @Excel(name = "监护人员")
    private String guarder;

    /** 施工人员 */
    @Excel(name = "施工人员")
    private String builder;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setThirdBuildId(Long thirdBuildId) 
    {
        this.thirdBuildId = thirdBuildId;
    }

    public Long getThirdBuildId() 
    {
        return thirdBuildId;
    }
    public void setDescribe(String describe) 
    {
        this.describe = describe;
    }

    public String getDescribe() 
    {
        return describe;
    }
    public void setImgurl(String imgurl) 
    {
        this.imgurl = imgurl;
    }

    public String getImgurl() 
    {
        return imgurl;
    }
    public void setGuarder(String guarder) 
    {
        this.guarder = guarder;
    }

    public String getGuarder() 
    {
        return guarder;
    }
    public void setBuilder(String builder) 
    {
        this.builder = builder;
    }

    public String getBuilder() 
    {
        return builder;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("thirdBuildId", getThirdBuildId())
            .append("describe", getDescribe())
            .append("imgurl", getImgurl())
            .append("guarder", getGuarder())
            .append("builder", getBuilder())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .toString();
    }
}
