package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 设备巡检执行对象 t_device_task_inspect
 * 
 * @author zehong
 * @date 2023-12-11
 */
public class TDeviceTaskInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** 任务id */
    @Excel(name = "任务id")
    private Long taskId;

    /** 设备id */
    @Excel(name = "设备id")
    private Long deviceId;

    /** 设备照片 */
    @Excel(name = "设备照片")
    private String meterImg;

    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 巡检人id */
    @Excel(name = "巡检人id")
    private Long adminId;

    /** 检查单json */
    @Excel(name = "检查单json")
    private String content;

    /** 是否有隐患，0没有，1有 */
    @Excel(name = "是否有隐患，0没有，1有")
    private Integer danger;

    /**设备名称*/
    private String deviceName;

    /**设备类型*/
    private Integer deviceType;

    /**设备编号*/
    private String deviceCode;

    /**巡检人*/
    private String inspector;

    /**巡检状态*/
    private Integer inspectStatus;

    private Long[] dangerarr;

    public Long[] getDangerarr() {
        return dangerarr;
    }

    public void setDangerarr(Long[] dangerarr) {
        this.dangerarr = dangerarr;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setDeviceId(Long deviceId) 
    {
        this.deviceId = deviceId;
    }

    public Long getDeviceId() 
    {
        return deviceId;
    }
    public void setMeterImg(String meterImg) 
    {
        this.meterImg = meterImg;
    }

    public String getMeterImg() 
    {
        return meterImg;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setDanger(Integer danger) 
    {
        this.danger = danger;
    }

    public Integer getDanger() 
    {
        return danger;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceCode() {
        return deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public String getInspector() {
        return inspector;
    }

    public void setInspector(String inspector) {
        this.inspector = inspector;
    }

    public Integer getInspectStatus() {
        return inspectStatus;
    }

    public void setInspectStatus(Integer inspectStatus) {
        this.inspectStatus = inspectStatus;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("taskId", getTaskId())
            .append("deviceId", getDeviceId())
            .append("meterImg", getMeterImg())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("adminId", getAdminId())
            .append("content", getContent())
            .append("danger", getDanger())
            .append("createTime", getCreateTime())
            .toString();
    }
}
