package com.zehong.web.controller.urgentplan;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUrgentContactsGroupInfo;
import com.zehong.system.service.ITUrgentContactsGroupInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急联系人分组Controller
 * 
 * @author zehong
 * @date 2024-12-31
 */
@RestController
@RequestMapping("/urgent/group")
public class TUrgentContactsGroupInfoController extends BaseController
{
    @Autowired
    private ITUrgentContactsGroupInfoService tUrgentContactsGroupInfoService;

    /**
     * 查询应急联系人分组列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        startPage();
        List<TUrgentContactsGroupInfo> list = tUrgentContactsGroupInfoService.selectTUrgentContactsGroupInfoList(tUrgentContactsGroupInfo);
        return getDataTable(list);
    }

    @GetMapping("/contactsInfoList")
    public AjaxResult contactsInfoList(TUrgentContactsGroupInfo tUrgentContactsGroupInfo){
        List<TUrgentContactsGroupInfo> list = tUrgentContactsGroupInfoService.selectTUrgentContactsGroupInfoList(tUrgentContactsGroupInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出应急联系人分组列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:export')")
    @Log(title = "应急联系人分组", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        List<TUrgentContactsGroupInfo> list = tUrgentContactsGroupInfoService.selectTUrgentContactsGroupInfoList(tUrgentContactsGroupInfo);
        ExcelUtil<TUrgentContactsGroupInfo> util = new ExcelUtil<TUrgentContactsGroupInfo>(TUrgentContactsGroupInfo.class);
        return util.exportExcel(list, "应急联系人分组数据");
    }

    /**
     * 获取应急联系人分组详细信息
     */
   // @PreAuthorize("@ss.hasPermi('system:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUrgentContactsGroupInfoService.selectTUrgentContactsGroupInfoById(id));
    }

    /**
     * 新增应急联系人分组
     */
    //@PreAuthorize("@ss.hasPermi('system:info:add')")
    @Log(title = "应急联系人分组", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        int result = tUrgentContactsGroupInfoService.insertTUrgentContactsGroupInfo(tUrgentContactsGroupInfo);
        return result>0 ? AjaxResult.success(tUrgentContactsGroupInfo) : AjaxResult.error() ;
    }

    /**
     * 修改应急联系人分组
     */
   // @PreAuthorize("@ss.hasPermi('system:info:edit')")
    @Log(title = "应急联系人分组", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUrgentContactsGroupInfo tUrgentContactsGroupInfo)
    {
        return toAjax(tUrgentContactsGroupInfoService.updateTUrgentContactsGroupInfo(tUrgentContactsGroupInfo));
    }

    /**
     * 删除应急联系人分组
     */
    //@PreAuthorize("@ss.hasPermi('system:info:remove')")
    @Log(title = "应急联系人分组", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUrgentContactsGroupInfoService.deleteTUrgentContactsGroupInfoByIds(ids));
    }


    /**
     * 根据组号删除
     * @param groupId 组号
     * @return
     */
    @GetMapping("/deleteTUrgentContactsGroupInfoByGroupId")
    public AjaxResult deleteTUrgentContactsGroupInfoByGroupId(@RequestParam(value="groupId") String groupId){
        return toAjax(tUrgentContactsGroupInfoService.deleteTUrgentContactsGroupInfoByGroupId(groupId));
    }
}
