package com.zehong.web.controller.pipetask;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeTaskInspect;
import com.zehong.system.service.ITPipeTaskInspectService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 管线巡线任务执行Controller
 * 
 * @author zehong
 * @date 2023-11-17
 */
@RestController
@RequestMapping("/pipetask/pipeinspect")
public class TPipeTaskInspectController extends BaseController
{
    @Autowired
    private ITPipeTaskInspectService tPipeTaskInspectService;

    /**
     * 查询管线巡线任务执行列表
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:pipeinspect:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPipeTaskInspect tPipeTaskInspect)
    {
        startPage();
        List<TPipeTaskInspect> list = tPipeTaskInspectService.selectTPipeTaskInspectList(tPipeTaskInspect);
        return getDataTable(list);
    }

    /**
     * 打卡排序
     * @param tPipeTaskInspect
     * @return
     */
    @GetMapping("/listDistance")
    public TableDataInfo selectPipeDistance(TPipeTaskInspect tPipeTaskInspect)
    {
        startPage();
        List<TPipeTaskInspect> list = tPipeTaskInspectService.selectPipeDistance(tPipeTaskInspect);
        return getDataTable(list);
    }

    /**
     * 导出管线巡线任务执行列表
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:pipeinspect:export')")
    @Log(title = "管线巡线任务执行", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeTaskInspect tPipeTaskInspect)
    {
        List<TPipeTaskInspect> list = tPipeTaskInspectService.selectTPipeTaskInspectList(tPipeTaskInspect);
        ExcelUtil<TPipeTaskInspect> util = new ExcelUtil<TPipeTaskInspect>(TPipeTaskInspect.class);
        return util.exportExcel(list, "管线巡线任务执行数据");
    }

    /**
     * 获取管线巡线任务执行详细信息
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:pipeinspect:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tPipeTaskInspectService.selectTPipeTaskInspectById(id));
    }

    /**
     * 新增管线巡线任务执行
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:pipeinspect:add')")
    @Log(title = "管线巡线任务执行", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeTaskInspect tPipeTaskInspect)
    {
        return toAjax(tPipeTaskInspectService.insertTPipeTaskInspect(tPipeTaskInspect));
    }

    /**
     * 修改管线巡线任务执行
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:pipeinspect:edit')")
    @Log(title = "管线巡线任务执行", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeTaskInspect tPipeTaskInspect)
    {
        return toAjax(tPipeTaskInspectService.updateTPipeTaskInspect(tPipeTaskInspect));
    }

    /**
     * 删除管线巡线任务执行
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:pipeinspect:remove')")
//    @Log(title = "管线巡线任务执行", businessType = BusinessType.DELETE)
//	@DeleteMapping("/{ids}")
//    public AjaxResult remove(@PathVariable Long[] ids)
//    {
//        return toAjax(tPipeTaskInspectService.deleteTPipeTaskInspectByIds(ids));
//    }

    @DeleteMapping("/{id}")
    public AjaxResult remove(@PathVariable Long id)
    {
        return toAjax(tPipeTaskInspectService.deleteTPipeTaskInspectById(id));
    }


    /**
     * 获取管道及打卡点信息
     * @param tPipeTaskInspect 打卡巡检实体
     * @return
     */
    @GetMapping("/selectPipeAndPointInspectInfo")
    public AjaxResult selectPipeAndPointInspectInfo(TPipeTaskInspect tPipeTaskInspect) {
        return AjaxResult.success(tPipeTaskInspectService.selectPipeAndPointInspectInfo(tPipeTaskInspect));
    }

    /**
     * 一天多检新增 20241223
     * @param tPipeTaskInspect
     * @return
     */
    @PostMapping("/moreDailyInspect")
    public AjaxResult moreDailyInspect(@RequestBody TPipeTaskInspect tPipeTaskInspect)
    {
        return toAjax(tPipeTaskInspectService.moreDailyInspect(tPipeTaskInspect));
    }

    /**
     * 查询管线巡线任务打卡点执行列表
     *
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行集合
     */
    @GetMapping("/selectTPipeTaskPointInspectList")
    public TableDataInfo selectTPipeTaskPointInspectList(TPipeTaskInspect tPipeTaskInspect){
        startPage();
        return getDataTable(tPipeTaskInspectService.selectTPipeTaskPointInspectList(tPipeTaskInspect));
    }
}
