package com.zehong.web.controller.linepatrol;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeUser;
import com.zehong.system.service.ITPipeUserService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 管线巡线人员分配Controller
 * 
 * @author zehong
 * @date 2023-11-16
 */
@RestController
@RequestMapping("/linePatrol/user")
public class TPipeUserController extends BaseController
{
    @Autowired
    private ITPipeUserService tPipeUserService;

    /**
     * 查询管线巡线人员分配列表
     */
    //@PreAuthorize("@ss.hasPermi('linePatrol:user:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPipeUser tPipeUser)
    {
        startPage();
        List<TPipeUser> list = tPipeUserService.selectTPipeUserList(tPipeUser);
        return getDataTable(list);
    }

    @GetMapping("/pipeUserList")
    public AjaxResult pipeUserList(TPipeUser tPipeUser){
        return AjaxResult.success(tPipeUserService.selectTPipeUserList(tPipeUser));
    }

    /**
     * 导出管线巡线人员分配列表
     */
    //@PreAuthorize("@ss.hasPermi('linePatrol:user:export')")
    @Log(title = "管线巡线人员分配", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeUser tPipeUser)
    {
        List<TPipeUser> list = tPipeUserService.selectTPipeUserList(tPipeUser);
        ExcelUtil<TPipeUser> util = new ExcelUtil<TPipeUser>(TPipeUser.class);
        return util.exportExcel(list, "管线巡线人员分配数据");
    }

    /**
     * 获取管线巡线人员分配详细信息
     */
    //@PreAuthorize("@ss.hasPermi('linePatrol:user:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tPipeUserService.selectTPipeUserById(id));
    }

    /**
     * 新增管线巡线人员分配
     */
    //@PreAuthorize("@ss.hasPermi('linePatrol:user:add')")
    @Log(title = "管线巡线人员分配", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeUser tPipeUser)
    {
        return toAjax(tPipeUserService.insertTPipeUser(tPipeUser));
    }

    /**
     * 修改管线巡线人员分配
     */
    //@PreAuthorize("@ss.hasPermi('linePatrol:user:edit')")
    @Log(title = "管线巡线人员分配", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeUser tPipeUser)
    {
        return toAjax(tPipeUserService.updateTPipeUser(tPipeUser));
    }

    /**
     * 删除管线巡线人员分配
     */
    //@PreAuthorize("@ss.hasPermi('linePatrol:user:remove')")
    @Log(title = "管线巡线人员分配", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tPipeUserService.deleteTPipeUserByIds(ids));
    }

     /**
     * 根据用户和管道主键删除
     * @param userId 用户主键
     * @param pipeId 管道主键
     * @return
     */
    @GetMapping("/deleteTPipeUserByUserIdAndPipeId")
    public AjaxResult deleteTPipeUserByUserIdAndPipeId(@RequestParam("userId") Long userId, @RequestParam("pipeId")Long pipeId){
        return toAjax(tPipeUserService.deleteTPipeUserByUserIdAndPipeId(userId,pipeId));
    }
}
