package com.zehong.web.controller.dangerinspect;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDangerInspectRecordInfo;
import com.zehong.system.service.ITDangerInspectRecordInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患日常巡检记录Controller
 * 
 * @author zehong
 * @date 2024-12-17
 */
@RestController
@RequestMapping("/dangerInspect/inspect")
public class TDangerInspectRecordInfoController extends BaseController
{
    @Autowired
    private ITDangerInspectRecordInfoService tDangerInspectRecordInfoService;

    /**
     * 查询隐患日常巡检记录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        startPage();
        List<TDangerInspectRecordInfo> list = tDangerInspectRecordInfoService.selectTDangerInspectRecordInfoList(tDangerInspectRecordInfo);
        return getDataTable(list);
    }

    /**
     * 导出隐患日常巡检记录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:export')")
    @Log(title = "隐患日常巡检记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        List<TDangerInspectRecordInfo> list = tDangerInspectRecordInfoService.selectTDangerInspectRecordInfoList(tDangerInspectRecordInfo);
        ExcelUtil<TDangerInspectRecordInfo> util = new ExcelUtil<TDangerInspectRecordInfo>(TDangerInspectRecordInfo.class);
        return util.exportExcel(list, "隐患日常巡检记录数据");
    }

    /**
     * 获取隐患日常巡检记录详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDangerInspectRecordInfoService.selectTDangerInspectRecordInfoById(id));
    }

    /**
     * 新增隐患日常巡检记录
     */
    //@PreAuthorize("@ss.hasPermi('system:info:add')")
    @Log(title = "隐患日常巡检记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        return toAjax(tDangerInspectRecordInfoService.insertTDangerInspectRecordInfo(tDangerInspectRecordInfo));
    }

    /**
     * 修改隐患日常巡检记录
     */
    //@PreAuthorize("@ss.hasPermi('system:info:edit')")
    @Log(title = "隐患日常巡检记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDangerInspectRecordInfo tDangerInspectRecordInfo)
    {
        return toAjax(tDangerInspectRecordInfoService.updateTDangerInspectRecordInfo(tDangerInspectRecordInfo));
    }

    /**
     * 删除隐患日常巡检记录
     */
    //@PreAuthorize("@ss.hasPermi('system:info:remove')")
    @Log(title = "隐患日常巡检记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDangerInspectRecordInfoService.deleteTDangerInspectRecordInfoByIds(ids));
    }
}
