package com.zehong.web.controller.baseinfo;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TIndustry;
import com.zehong.system.service.ITIndustryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 工业用户Controller
 * 
 * @author zehong
 * @date 2023-11-04
 */
@RestController
@RequestMapping("/baseinfo/industry")
public class TIndustryController extends BaseController
{
    @Autowired
    private ITIndustryService tIndustryService;

    /**
     * 查询工业用户列表
     */
    //@PreAuthorize("@ss.hasPermi('baseinfo:industry:list')")
    @GetMapping("/list")
    public TableDataInfo list(TIndustry tIndustry)
    {
        startPage();
        List<TIndustry> list = tIndustryService.selectTIndustryList(tIndustry);
        return getDataTable(list);
    }

    /**
     * 导出工业用户列表
     */
    //@PreAuthorize("@ss.hasPermi('baseinfo:industry:export')")
    @Log(title = "工业用户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TIndustry tIndustry)
    {
        List<TIndustry> list = tIndustryService.selectTIndustryList(tIndustry);
        ExcelUtil<TIndustry> util = new ExcelUtil<TIndustry>(TIndustry.class);
        return util.exportExcel(list, "工业用户数据");
    }

    /**
     * 获取工业用户详细信息
     */
    //@PreAuthorize("@ss.hasPermi('baseinfo:industry:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tIndustryService.selectTIndustryById(id));
    }

    @GetMapping(value = "industryInfo/{id}")
    public AjaxResult getIndustryInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tIndustryService.selectTIndustryById(id));
    }

    /**
     * 新增工业用户
     */
    //@PreAuthorize("@ss.hasPermi('baseinfo:industry:add')")
    @Log(title = "工业用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TIndustry tIndustry)
    {
        return toAjax(tIndustryService.insertTIndustry(tIndustry));
    }

    /**
     * 修改工业用户
     */
    //@PreAuthorize("@ss.hasPermi('baseinfo:industry:edit')")
    @Log(title = "工业用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TIndustry tIndustry)
    {
        return toAjax(tIndustryService.updateTIndustry(tIndustry));
    }

    /**
     * 删除工业用户
     */
    //@PreAuthorize("@ss.hasPermi('baseinfo:industry:remove')")
    @Log(title = "工业用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tIndustryService.deleteTIndustryByIds(ids));
    }


    /**
     * 查询工业用户入户安检信息
     * @param industry 工业用户信息
     * @return
     */
    @GetMapping("/getIndustryInspectInfo")
    public TableDataInfo getIndustryInspectInfo(TIndustry industry){
        startPage();
        return getDataTable(tIndustryService.getIndustryInspectInfo(industry));
    }

}
