package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TUrgentPlan;

/**
 * 应急预案Service接口
 * 
 * @author zehong
 * @date 2023-12-19
 */
public interface ITUrgentPlanService 
{
    /**
     * 查询应急预案
     * 
     * @param id 应急预案ID
     * @return 应急预案
     */
    public TUrgentPlan selectTUrgentPlanById(Long id);

    /**
     * 查询应急预案列表
     * 
     * @param tUrgentPlan 应急预案
     * @return 应急预案集合
     */
    public List<TUrgentPlan> selectTUrgentPlanList(TUrgentPlan tUrgentPlan);

    /**
     * 新增应急预案
     * 
     * @param tUrgentPlan 应急预案
     * @return 结果
     */
    public int insertTUrgentPlan(TUrgentPlan tUrgentPlan);

    /**
     * 修改应急预案
     * 
     * @param tUrgentPlan 应急预案
     * @return 结果
     */
    public int updateTUrgentPlan(TUrgentPlan tUrgentPlan);

    /**
     * 批量删除应急预案
     * 
     * @param ids 需要删除的应急预案ID
     * @return 结果
     */
    public int deleteTUrgentPlanByIds(Long[] ids);

    /**
     * 删除应急预案信息
     * 
     * @param id 应急预案ID
     * @return 结果
     */
    public int deleteTUrgentPlanById(Long id);
}
