import request from '@/utils/request'

// 查询报警器报警记录列表
export function listAlarm(query) {
  return request({
    url: '/gas/alarm/list',
    method: 'get',
    params: query
  })
}

// 查询报警器报警记录详细
export function getAlarm(id) {
  return request({
    url: '/gas/alarm/' + id,
    method: 'get'
  })
}

// 新增报警器报警记录
export function addAlarm(data) {
  return request({
    url: '/gas/alarm',
    method: 'post',
    data: data
  })
}

// 修改报警器报警记录
export function updateAlarm(data) {
  return request({
    url: '/gas/alarm',
    method: 'put',
    data: data
  })
}

// 删除报警器报警记录
export function delAlarm(id) {
  return request({
    url: '/gas/alarm/' + id,
    method: 'delete'
  })
}

// 导出报警器报警记录
export function exportAlarm(query) {
  return request({
    url: '/gas/alarm/export',
    method: 'get',
    params: query
  })
}

//获取报警信息
export function getCacheAlarmInfo(query) {
  return request({
    url: '/gas/alarm/getCacheAlarmInfo',
    method: 'get',
    params: query
  })
}
