import request from '@/utils/request'

// 查询应急处置步骤列表
export function listStep(query) {
  return request({
    url: '/emergency/step/list',
    method: 'get',
    params: query
  })
}

// 查询应急处置步骤详细
export function getStep(stepId) {
  return request({
    url: '/emergency/step/' + stepId,
    method: 'get'
  })
}

// 新增应急处置步骤
export function addStep(data) {
  return request({
    url: '/emergency/step',
    method: 'post',
    data: data
  })
}

// 修改应急处置步骤
export function updateStep(data) {
  return request({
    url: '/emergency/step',
    method: 'put',
    data: data
  })
}

// 删除应急处置步骤
export function delStep(stepId) {
  return request({
    url: '/emergency/step/' + stepId,
    method: 'delete'
  })
}

// 导出应急处置步骤
export function exportStep(query) {
  return request({
    url: '/emergency/step/export',
    method: 'get',
    params: query
  })
}

//所有处置步骤信息
export function stepListInfo(query) {
  return request({
    url: '/emergency/step/stepListInfo',
    method: 'get',
    params: query
  })
}
