import request from '@/utils/request';
import exportRequest from '@/utils/export-request';

// 查询安检任务执行列表
export function listInspect(query) {
  return request({
    url: '/checktask/inspect/list',
    method: 'get',
    params: query
  })
}
//居民安检执行情况
export function jmlist(query) {
  return request({
    url: '/checktask/inspect/jmlist',
    method: 'get',
    params: query
  })
}
//居民安检执行情况
export function juminlist(query) {
  return request({
    url: '/checktask/inspect/juminlist',
    method: 'get',
    params: query
  })
}
//餐饮安检执行情况
export function cylist(query) {
  return request({
    url: '/checktask/inspect/cylist',
    method: 'get',
    params: query
  })
}


// 查询安检任务执行详细
export function getInspect(id) {
  return request({
    url: '/checktask/inspect/' + id,
    method: 'get'
  })
}

// 新增安检任务执行
export function addInspect(data) {
  return request({
    url: '/checktask/inspect',
    method: 'post',
    data: data
  })
}

// 修改安检任务执行
export function updateInspect(data) {
  return request({
    url: '/checktask/inspect',
    method: 'put',
    data: data
  })
}

// 删除安检任务执行
export function delInspect(id) {
  return request({
    url: '/checktask/inspect/' + id,
    method: 'delete'
  })
}

// 导出安检任务执行
export function exportInspect(query) {
  return request({
    url: '/checktask/inspect/export',
    method: 'get',
    params: query
  })
}

//入户安检统计
export function taskInspectStatistics(query) {
  return request({
    url: '/checktask/inspect/taskInspectStatistics',
    method: 'get',
    params: query
  })
}


export function jmInspectExport(query){
  return request({
    url: '/checktask/inspect/jmInspectExport',
    method: 'get',
    params: query
  })
}

//安检单压缩包导出
export function exportInspectZip(query){
  return exportRequest({
    url: '/checktask/inspect/exportInspectZip',
    method: 'get',
    params: query
  })
}

//到访不遇查询
export function selectVisitorMissInfo(query) {
  return request({
    url: '/checktask/inspect/selectVisitorMissInfo',
    method: 'get',
    params: query
  })
}


export function visitorMissInfoExport(query) {
  return request({
    url: '/checktask/inspect/visitorMissInfoExport',
    method: 'get',
    params: query
  })
}

//居民安检统计
export function statisticsInspectItems(query) {
  return request({
    url: '/checktask/inspect/statisticsInspectItems',
    method: 'get',
    params: query
  })
}
