import request from '@/utils/request'

// 查询场站信息列表
export function listInfo(query) {
  return request({
    url: '/baseInfo/station/list',
    method: 'get',
    params: query
  })
}

//查询所有场站信息
export function stationInfoList(query) {
  return request({
    url: '/baseInfo/station/stationInfoList',
    method: 'get',
    params: query
  })
}

// 查询场站信息详细
export function getInfo(siteStationId) {
  return request({
    url: '/baseInfo/station/' + siteStationId,
    method: 'get'
  })
}

// 新增场站信息
export function addInfo(data) {
  return request({
    url: '/baseInfo/station',
    method: 'post',
    data: data
  })
}

// 修改场站信息
export function updateInfo(data) {
  return request({
    url: '/baseInfo/station',
    method: 'put',
    data: data
  })
}

// 删除场站信息
export function delInfo(siteStationId) {
  return request({
    url: '/baseInfo/station/' + siteStationId,
    method: 'delete'
  })
}

// 导出场站信息
export function exportInfo(query) {
  return request({
    url: '/baseInfo/station/export',
    method: 'get',
    params: query
  })
}
