import request from '@/utils/request'

// 查询管道信息列表
export function listInfo(query) {
  return request({
    url: '/baseInfo/pipe/list',
    method: 'get',
    params: query
  })
}

//查询所有管道信息
export function pipeInfoList(query) {
  return request({
    url: '/baseInfo/pipe/pipeList',
    method: 'get',
    params: query
  })
}

// 查询管道信息详细
export function getInfo(pipeId) {
  return request({
    url: '/baseInfo/pipe/' + pipeId,
    method: 'get'
  })
}

// 新增管道信息
export function addInfo(data) {
  return request({
    url: '/baseInfo/pipe',
    method: 'post',
    data: data
  })
}

// 修改管道信息
export function updateInfo(data) {
  return request({
    url: '/baseInfo/pipe',
    method: 'put',
    data: data
  })
}

// 删除管道信息
export function delInfo(pipeId) {
  return request({
    url: '/baseInfo/pipe/' + pipeId,
    method: 'delete'
  })
}

// 导出管道信息
export function exportInfo(query) {
  return request({
    url: '/baseInfo/pipe/export',
    method: 'get',
    params: query
  })
}

//根据用户查询管道
export function selectPipeInfoByUser(query){
  return request({
    url: '/baseInfo/pipe/selectPipeInfoByUser',
    method: 'get',
    params: query
  })
}
