package com.zehong.system.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTaskMapper;
import com.zehong.system.domain.TTask;
import com.zehong.system.service.ITTaskService;
import org.springframework.util.CollectionUtils;

/**
 * 入户安检任务Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-06
 */
@Service
public class TTaskServiceImpl implements ITTaskService 
{
    @Autowired
    private TTaskMapper tTaskMapper;

    /**
     * 查询入户安检任务
     * 
     * @param id 入户安检任务ID
     * @return 入户安检任务
     */
    @Override
    public TTask selectTTaskById(Long id)
    {
        return tTaskMapper.selectTTaskById(id);
    }

    /**
     * 查询入户安检任务列表
     * 
     * @param tTask 入户安检任务
     * @return 入户安检任务
     */
    @Override
    public List<TTask> selectTTaskList(TTask tTask)
    {
        return tTaskMapper.selectTTaskList(tTask);
    }

    /**
     * 新增入户安检任务
     * 
     * @param tTask 入户安检任务
     * @return 结果
     */
    @Override
    public int insertTTask(TTask tTask)
    {
        tTask.setCreateTime(DateUtils.getNowDate());
        return tTaskMapper.insertTTask(tTask);
    }

    /**
     * 修改入户安检任务
     * 
     * @param tTask 入户安检任务
     * @return 结果
     */
    @Override
    public int updateTTask(TTask tTask)
    {
        return tTaskMapper.updateTTask(tTask);
    }

    /**
     * 批量删除入户安检任务
     * 
     * @param ids 需要删除的入户安检任务ID
     * @return 结果
     */
    @Override
    public int deleteTTaskByIds(Long[] ids)
    {
        return tTaskMapper.deleteTTaskByIds(ids);
    }

    /**
     * 删除入户安检任务信息
     * 
     * @param id 入户安检任务ID
     * @return 结果
     */
    @Override
    public int deleteTTaskById(Long id)
    {
        return tTaskMapper.deleteTTaskById(id);
    }

    /**
     * 根据任务类型获取最新任务
     * @param param 参数
     * @return
     */
    @Override
    public TTask selectCurrentTaskByType(Map<String,Object> param){
        return tTaskMapper.selectCurrentTaskByType(param);
    }

    /**
     * 小程序任务列表
     * @param tTask
     * @return
     */
    @Override
    public  List<TTask> selecttasknums(TTask tTask){
        //安检数改为当前登录人安检数selfInspectNum  2024-05-28需求要求
        tTask.getParams().put("memberId",SecurityUtils.getLoginUser().getUser().getUserId());
        return tTaskMapper.selecttasknums(tTask);
    }

    /**
     * 任务详情 任务统计
     * @param taskId 任务主键
     * @return
     */
    @Override
    public Map<String,Object> taskDetailInfo(Long taskId){
        return tTaskMapper.taskDetailInfo(taskId);
    }

    /**
     * 任务详情任务进度统计
     * @param param
     * @return
     */
    @Override
    public Map<String,Object> taskInspectDetailInfo(Map<String,Object> param){
        return tTaskMapper.taskInspectDetailInfo(param);
    }

    /**
     * 任务详情隐患统计
     * @param taskId 任务主键
     * @return
     */
    @Override
    public Map<String,Object> taskInspectDangerDetailInfo(Long taskId){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        List<SysRole> visitor = roles.stream().filter(item ->"visitor".equals(item.getRoleKey())).collect(Collectors.toList());
        Map<String,Object> param = new HashMap<>();
        param.put("taskId",taskId);
        if(!CollectionUtils.isEmpty(visitor)){
            param.put("isVisitor","1");
        }
        return tTaskMapper.taskInspectDangerDetailInfo(param);
    }


}
