package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TCommunityMapper;
import com.zehong.system.domain.TCommunity;
import com.zehong.system.service.ITCommunityService;

/**
 * 居民小区（村）Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-03
 */
@Service
public class TCommunityServiceImpl implements ITCommunityService 
{
    @Autowired
    private TCommunityMapper tCommunityMapper;

    /**
     * 查询居民小区（村）
     * 
     * @param id 居民小区（村）ID
     * @return 居民小区（村）
     */
    @Override
    public TCommunity selectTCommunityById(Long id)
    {
        return tCommunityMapper.selectTCommunityById(id);
    }

    /**
     * 查询居民小区（村）列表
     * 
     * @param tCommunity 居民小区（村）
     * @return 居民小区（村）
     */
    @Override
    public List<TCommunity> selectTCommunityList(TCommunity tCommunity)
    {
        return tCommunityMapper.selectTCommunityList(tCommunity);
    }

    /**
     * 新增居民小区（村）
     * 
     * @param tCommunity 居民小区（村）
     * @return 结果
     */
    @Override
    public int insertTCommunity(TCommunity tCommunity)
    {
        return tCommunityMapper.insertTCommunity(tCommunity);
    }

    /**
     * 修改居民小区（村）
     * 
     * @param tCommunity 居民小区（村）
     * @return 结果
     */
    @Override
    public int updateTCommunity(TCommunity tCommunity)
    {
        return tCommunityMapper.updateTCommunity(tCommunity);
    }

    /**
     * 批量删除居民小区（村）
     * 
     * @param ids 需要删除的居民小区（村）ID
     * @return 结果
     */
    @Override
    public int deleteTCommunityByIds(Long[] ids)
    {
        return tCommunityMapper.deleteTCommunityByIds(ids);
    }

    /**
     * 删除居民小区（村）信息
     * 
     * @param id 居民小区（村）ID
     * @return 结果
     */
    @Override
    public int deleteTCommunityById(Long id)
    {
        return tCommunityMapper.deleteTCommunityById(id);
    }
}
