package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TAreaMapper;
import com.zehong.system.domain.TArea;
import com.zehong.system.service.ITAreaService;

/**
 * 地区县镇Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-03
 */
@Service
public class TAreaServiceImpl implements ITAreaService 
{
    @Autowired
    private TAreaMapper tAreaMapper;

    /**
     * 查询地区县镇
     * 
     * @param id 地区县镇ID
     * @return 地区县镇
     */
    @Override
    public TArea selectTAreaById(Long id)
    {
        return tAreaMapper.selectTAreaById(id);
    }

    /**
     * 查询地区县镇列表
     * 
     * @param tArea 地区县镇
     * @return 地区县镇
     */
    @Override
    public List<TArea> selectTAreaList(TArea tArea)
    {
        return tAreaMapper.selectTAreaList(tArea);
    }

    /**
     * 新增地区县镇
     * 
     * @param tArea 地区县镇
     * @return 结果
     */
    @Override
    public int insertTArea(TArea tArea)
    {
        tArea.setCreateTime(DateUtils.getNowDate());
        return tAreaMapper.insertTArea(tArea);
    }

    /**
     * 修改地区县镇
     * 
     * @param tArea 地区县镇
     * @return 结果
     */
    @Override
    public int updateTArea(TArea tArea)
    {
        return tAreaMapper.updateTArea(tArea);
    }

    /**
     * 批量删除地区县镇
     * 
     * @param ids 需要删除的地区县镇ID
     * @return 结果
     */
    @Override
    public int deleteTAreaByIds(Long[] ids)
    {
        return tAreaMapper.deleteTAreaByIds(ids);
    }

    /**
     * 删除地区县镇信息
     * 
     * @param id 地区县镇ID
     * @return 结果
     */
    @Override
    public int deleteTAreaById(Long id)
    {
        return tAreaMapper.deleteTAreaById(id);
    }
}
