package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TUser;

/**
 * 居民用户Service接口
 * 
 * @author zehong
 * @date 2023-11-03
 */
public interface ITUserService 
{
    /**
     * 查询居民用户
     * 
     * @param id 居民用户ID
     * @return 居民用户
     */
    public TUser selectTUserById(Long id);

    /**
     * 查询居民用户列表
     * 
     * @param tUser 居民用户
     * @return 居民用户集合
     */
    public List<TUser> selectTUserList(TUser tUser);

    /**
     * 新增居民用户
     * 
     * @param tUser 居民用户
     * @return 结果
     */
    public int insertTUser(TUser tUser);

    /**
     * 修改居民用户
     * 
     * @param tUser 居民用户
     * @return 结果
     */
    public int updateTUser(TUser tUser);

    /**
     * 批量删除居民用户
     * 
     * @param ids 需要删除的居民用户ID
     * @return 结果
     */
    public int deleteTUserByIds(Long[] ids);

    /**
     * 删除居民用户信息
     * 
     * @param id 居民用户ID
     * @return 结果
     */
    public int deleteTUserById(Long id);
}
