package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSpecialDocumentSign;

/**
 * 特殊作业单签字Service接口
 * 
 * @author zehong
 * @date 2023-12-04
 */
public interface ITSpecialDocumentSignService 
{
    /**
     * 查询特殊作业单签字
     * 
     * @param id 特殊作业单签字ID
     * @return 特殊作业单签字
     */
    public TSpecialDocumentSign selectTSpecialDocumentSignById(Long id);

    /**
     * 查询特殊作业单签字列表
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 特殊作业单签字集合
     */
    public List<TSpecialDocumentSign> selectTSpecialDocumentSignList(TSpecialDocumentSign tSpecialDocumentSign);

    /**
     * 新增特殊作业单签字
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 结果
     */
    public int insertTSpecialDocumentSign(TSpecialDocumentSign tSpecialDocumentSign);

    /**
     * 修改特殊作业单签字
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 结果
     */
    public int updateTSpecialDocumentSign(TSpecialDocumentSign tSpecialDocumentSign);
    public int updateSign(TSpecialDocumentSign tSpecialDocumentSign);

    /**
     * 批量删除特殊作业单签字
     * 
     * @param ids 需要删除的特殊作业单签字ID
     * @return 结果
     */
    public int deleteTSpecialDocumentSignByIds(Long[] ids);

    /**
     * 删除特殊作业单签字信息
     * 
     * @param id 特殊作业单签字ID
     * @return 结果
     */
    public int deleteTSpecialDocumentSignById(Long id);
}
