package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 管线巡线人员分配对象 t_pipe_user
 * 
 * @author zehong
 * @date 2023-11-16
 */
public class TPipeUser extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 巡线员id */
    @Excel(name = "巡线员id")
    private Long userId;

    /** 管线id */
    @Excel(name = "管线id")
    private Long pipeId;

    /** 创建人 */
    @Excel(name = "创建人")
    private Long adminId;

    /** 管道名称 */
    private String pipeName;

    /** 坐标 */
    private String coordinates;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setPipeId(Long pipeId) 
    {
        this.pipeId = pipeId;
    }

    public Long getPipeId() 
    {
        return pipeId;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }

    public String getPipeName() {
        return pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public String getCoordinates() {
        return coordinates;
    }

    public void setCoordinates(String coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("userId", getUserId())
            .append("pipeId", getPipeId())
            .append("adminId", getAdminId())
            .append("createTime", getCreateTime())
            .toString();
    }
}
