package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 监测设备数据对象 t_gas_data
 * 
 * @author zehong
 * @date 2024-03-02
 */
public class TGasData extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String number;

    @Excel(name = "所属厂家",dictType = "t_gas_alarm_type")
    private Integer type;

    /** 安装位置 */
    @Excel(name = "安装位置")
    private String position;

    /** 高报 */
    @Excel(name = "高报")
    private Long highAlarm;

    /** 高高报 */
    @Excel(name = "高高报")
    private Long highHighAlarm;

    /** 低报 */
    @Excel(name = "低报")
    private Long lowAlarm;

    /** 低低报 */
    @Excel(name = "低低报")
    private Long lowLowAlarm;

    /** 量程 */
    @Excel(name = "量程")
    private String range;

    /** 单位 */
    @Excel(name = "单位")
    private String unit;

    /** 位号 */
    @Excel(name = "位号")
    private String tag;

    /** $column.columnComment */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "位号", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createdAt;

    /**上报状态*/
    private String reportStatus;

    /**上报参数*/
    private String reportParam;

    /**上报时间*/
    private String reportTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setNumber(String number) 
    {
        this.number = number;
    }

    public String getNumber() 
    {
        return number;
    }
    public void setPosition(String position) 
    {
        this.position = position;
    }

    public String getPosition() 
    {
        return position;
    }
    public void setHighAlarm(Long highAlarm) 
    {
        this.highAlarm = highAlarm;
    }

    public Long getHighAlarm() 
    {
        return highAlarm;
    }
    public void setHighHighAlarm(Long highHighAlarm) 
    {
        this.highHighAlarm = highHighAlarm;
    }

    public Long getHighHighAlarm() 
    {
        return highHighAlarm;
    }
    public void setLowAlarm(Long lowAlarm) 
    {
        this.lowAlarm = lowAlarm;
    }

    public Long getLowAlarm() 
    {
        return lowAlarm;
    }
    public void setLowLowAlarm(Long lowLowAlarm) 
    {
        this.lowLowAlarm = lowLowAlarm;
    }

    public Long getLowLowAlarm() 
    {
        return lowLowAlarm;
    }
    public void setRange(String range) 
    {
        this.range = range;
    }

    public String getRange() 
    {
        return range;
    }
    public void setUnit(String unit) 
    {
        this.unit = unit;
    }

    public String getUnit() 
    {
        return unit;
    }
    public void setTag(String tag) 
    {
        this.tag = tag;
    }

    public String getTag() 
    {
        return tag;
    }
    public void setCreatedAt(Date createdAt) 
    {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() 
    {
        return createdAt;
    }

    public String getReportStatus() {
        return reportStatus;
    }

    public void setReportStatus(String reportStatus) {
        this.reportStatus = reportStatus;
    }

    public String getReportParam() {
        return reportParam;
    }

    public void setReportParam(String reportParam) {
        this.reportParam = reportParam;
    }

    public String getReportTime() {
        return reportTime;
    }

    public void setReportTime(String reportTime) {
        this.reportTime = reportTime;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("number", getNumber())
            .append("position", getPosition())
            .append("highAlarm", getHighAlarm())
            .append("highHighAlarm", getHighHighAlarm())
            .append("lowAlarm", getLowAlarm())
            .append("lowLowAlarm", getLowLowAlarm())
            .append("range", getRange())
            .append("unit", getUnit())
            .append("tag", getTag())
            .append("createdAt", getCreatedAt())
            .toString();
    }
}
