package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急报警关联关系对象 t_emergency_alarm_relation_info
 * 
 * @author zehong
 * @date 2024-12-09
 */
public class TEmergencyAlarmRelationInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 应急报警主键 */
    @Excel(name = "应急报警主键")
    private Long alarmId;

    /** 报警关联表主键(预案/处置人) */
    @Excel(name = "报警关联表主键(预案/处置人)")
    private Long relationId;

    /** 报警关联表主键类型: 1预案 2处置人) */
    @Excel(name = "报警关联表主键类型: 1预案 2处置人)")
    private String relationType;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setAlarmId(Long alarmId) 
    {
        this.alarmId = alarmId;
    }

    public Long getAlarmId() 
    {
        return alarmId;
    }
    public void setRelationId(Long relationId) 
    {
        this.relationId = relationId;
    }

    public Long getRelationId() 
    {
        return relationId;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("alarmId", getAlarmId())
            .append("relationId", getRelationId())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .toString();
    }
}
