package com.zehong.web.controller.urgentplan;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUrgentPlan;
import com.zehong.system.service.ITUrgentPlanService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急预案Controller
 * 
 * @author zehong
 * @date 2023-12-19
 */
@RestController
@RequestMapping("/urgent/plan")
public class TUrgentPlanController extends BaseController
{
    @Autowired
    private ITUrgentPlanService tUrgentPlanService;

    /**
     * 查询应急预案列表
     */
    //@PreAuthorize("@ss.hasPermi('urgent:plan:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUrgentPlan tUrgentPlan)
    {
        startPage();
        List<TUrgentPlan> list = tUrgentPlanService.selectTUrgentPlanList(tUrgentPlan);
        return getDataTable(list);
    }

    @GetMapping("/planList")
    public AjaxResult planList(TUrgentPlan tUrgentPlan)
    {
        List<TUrgentPlan> list = tUrgentPlanService.selectTUrgentPlanList(tUrgentPlan);
        return AjaxResult.success(list);
    }

    /**
     * 导出应急预案列表
     */
    @PreAuthorize("@ss.hasPermi('urgent:plan:export')")
    @Log(title = "应急预案", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUrgentPlan tUrgentPlan)
    {
        List<TUrgentPlan> list = tUrgentPlanService.selectTUrgentPlanList(tUrgentPlan);
        ExcelUtil<TUrgentPlan> util = new ExcelUtil<TUrgentPlan>(TUrgentPlan.class);
        return util.exportExcel(list, "应急预案数据");
    }

    /**
     * 获取应急预案详细信息
     */
    //@PreAuthorize("@ss.hasPermi('urgent:plan:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUrgentPlanService.selectTUrgentPlanById(id));
    }

    /**
     * 新增应急预案
     */
    @PreAuthorize("@ss.hasPermi('urgent:plan:add')")
    @Log(title = "应急预案", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUrgentPlan tUrgentPlan)
    {
        return toAjax(tUrgentPlanService.insertTUrgentPlan(tUrgentPlan));
    }

    /**
     * 修改应急预案
     */
    @PreAuthorize("@ss.hasPermi('urgent:plan:edit')")
    @Log(title = "应急预案", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUrgentPlan tUrgentPlan)
    {
        return toAjax(tUrgentPlanService.updateTUrgentPlan(tUrgentPlan));
    }

    /**
     * 删除应急预案
     */
    @PreAuthorize("@ss.hasPermi('urgent:plan:remove')")
    @Log(title = "应急预案", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUrgentPlanService.deleteTUrgentPlanByIds(ids));
    }
}
