package com.zehong.web.controller.specialworkpermit;

import java.util.List;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSpecialDocument;
import com.zehong.system.service.ITSpecialDocumentService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 特殊作业单Controller
 * 
 * @author zehong
 * @date 2023-12-04
 */
@RestController
@RequestMapping("/workPermit/document")
public class TSpecialDocumentController extends BaseController
{
    @Autowired
    private ITSpecialDocumentService tSpecialDocumentService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询特殊作业单列表
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:list')")
    @GetMapping("/list")
    public TableDataInfo list(TSpecialDocument tSpecialDocument)
    {
        startPage();
        List<TSpecialDocument> list = tSpecialDocumentService.selectTSpecialDocumentList(tSpecialDocument);
        return getDataTable(list);
    }
    /**
     * 查询特殊作业单列表
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:list')")
    @GetMapping("/specialList")
    public TableDataInfo selectSpecialListwx(TSpecialDocument tSpecialDocument)
    {
        LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
        tSpecialDocument.setUserId(loginUser.getUser().getUserId());
        startPage();
        List<TSpecialDocument> list = tSpecialDocumentService.selectSpecialListwx(tSpecialDocument);
        return getDataTable(list);
    }

    /**
     * 导出特殊作业单列表
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:export')")
    @Log(title = "特殊作业单", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSpecialDocument tSpecialDocument)
    {
        List<TSpecialDocument> list = tSpecialDocumentService.selectTSpecialDocumentList(tSpecialDocument);
        ExcelUtil<TSpecialDocument> util = new ExcelUtil<TSpecialDocument>(TSpecialDocument.class);
        return util.exportExcel(list, "特殊作业单数据");
    }

    /**
     * 获取特殊作业单详细信息
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSpecialDocumentService.selectTSpecialDocumentById(id));
    }

    /**
     * 新增特殊作业单
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:add')")
    @Log(title = "特殊作业单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSpecialDocument tSpecialDocument)
    {
        if(tSpecialDocument.getUserId()==null){
            LoginUser loginUser = tokenService.getLoginUser(ServletUtils.getRequest());
            tSpecialDocument.setUserId(loginUser.getUser().getUserId());
            tSpecialDocument.setDeptId(loginUser.getUser().getDeptId());
        }
        Integer a = tSpecialDocumentService.insertTSpecialDocument(tSpecialDocument);
        return AjaxResult.success(tSpecialDocument);
    }

    /**
     * 修改特殊作业单
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:edit')")
    @Log(title = "特殊作业单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSpecialDocument tSpecialDocument)
    {
        return toAjax(tSpecialDocumentService.updateTSpecialDocument(tSpecialDocument));
    }

    /**
     * 删除特殊作业单
     */
    //@PreAuthorize("@ss.hasPermi('workPermit:document:remove')")
    @Log(title = "特殊作业单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSpecialDocumentService.deleteTSpecialDocumentByIds(ids));
    }
}
