package com.zehong.web.controller.pipetask;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zehong.common.core.domain.model.LoginUser;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.vo.TaskInspectStatisticsByPipVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPipeTask;
import com.zehong.system.service.ITPipeTaskService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

import javax.servlet.http.HttpServletRequest;

/**
 * 管线巡线任务Controller
 * 
 * @author zehong
 * @date 2023-11-17
 */
@RestController
@RequestMapping("/pipetask/task")
public class TPipeTaskController extends BaseController
{
    @Autowired
    private ITPipeTaskService tPipeTaskService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询管线巡线任务列表
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:task:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPipeTask tPipeTask)
    {
        startPage();
        List<TPipeTask> list = tPipeTaskService.selectTPipeTaskList(tPipeTask);
        return getDataTable(list);
    }
    @GetMapping("/wxpipelist")
    public TableDataInfo wxpipelist(TPipeTask tPipeTask)
    {
        startPage();
        List<TPipeTask> list = tPipeTaskService.selectTwxPipeTaskList(tPipeTask);
        return getDataTable(list);
    }
    /**
     * 导出管线巡线任务列表
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:task:export')")
    @Log(title = "管线巡线任务", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPipeTask tPipeTask)
    {
        List<TPipeTask> list = tPipeTaskService.selectTPipeTaskList(tPipeTask);
        ExcelUtil<TPipeTask> util = new ExcelUtil<TPipeTask>(TPipeTask.class);
        return util.exportExcel(list, "管线巡线任务数据");
    }

    /**
     * 获取管线巡线任务详细信息
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:task:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tPipeTaskService.selectTPipeTaskById(id));
    }

    /**
     * 新增管线巡线任务
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:task:add')")
    @Log(title = "管线巡线任务", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPipeTask tPipeTask, HttpServletRequest request)
    {
        LoginUser user = tokenService.getLoginUser(request);
        tPipeTask.setAdminId(user.getUser().getUserId());
        return toAjax(tPipeTaskService.insertTPipeTask(tPipeTask));
    }

    /**
     * 修改管线巡线任务
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:task:edit')")
    @Log(title = "管线巡线任务", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPipeTask tPipeTask)
    {
        return toAjax(tPipeTaskService.updateTPipeTask(tPipeTask));
    }

    /**
     * 删除管线巡线任务
     */
    //@PreAuthorize("@ss.hasPermi('pipetask:task:remove')")
    @Log(title = "管线巡线任务", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tPipeTaskService.deleteTPipeTaskByIds(ids));
    }


    /**
     * 巡线人巡线点统计
     * @param taskId 巡线任务主键
     * @return
     */
    @GetMapping("/selectTaskInspectStatisticsByUser")
    public TableDataInfo selectTaskInspectStatisticsByUser(@RequestParam(value = "taskId") Long taskId,@RequestParam(value = "inspector",required = false)String inspector){
        startPage();
        Map<String,Object> param = new HashMap<>();
        param.put("taskId",taskId);
        param.put("inspector",inspector);
        return getDataTable(tPipeTaskService.selectTaskInspectStatisticsByUser(param));
    }

    /**
     * 管道巡检点统计
     * @param param 入参
     * @return
     */
    @GetMapping("/selectTaskInspectStatisticsByPipe")
    public TableDataInfo selectTaskInspectStatisticsByPipe(TaskInspectStatisticsByPipVo param){
        startPage();
        return getDataTable(tPipeTaskService.selectTaskInspectStatisticsByPipe(param));
    }
}
