package com.zehong.web.controller.gasdata;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TGasAlarm;
import com.zehong.system.service.ITGasAlarmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 报警器报警记录Controller
 * 
 * @author zehong
 * @date 2024-09-10
 */
@RestController
@RequestMapping("/gas/alarm")
public class TGasAlarmController extends BaseController
{
    @Autowired
    private ITGasAlarmService tGasAlarmService;

    /**
     * 查询报警器报警记录列表
     */
    @PreAuthorize("@ss.hasPermi('gas:alarm:list')")
    @GetMapping("/list")
    public TableDataInfo list(TGasAlarm tGasAlarm)
    {
        startPage();
        List<TGasAlarm> list = tGasAlarmService.selectTGasAlarmList(tGasAlarm);
        return getDataTable(list);
    }

    /**
     * 导出报警器报警记录列表
     */
    @PreAuthorize("@ss.hasPermi('gas:alarm:export')")
    @Log(title = "报警器报警记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGasAlarm tGasAlarm)
    {
        List<TGasAlarm> list = tGasAlarmService.selectTGasAlarmList(tGasAlarm);
        ExcelUtil<TGasAlarm> util = new ExcelUtil<TGasAlarm>(TGasAlarm.class);
        return util.exportExcel(list, "报警器报警记录数据");
    }

    /**
     * 获取报警器报警记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('gas:alarm:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tGasAlarmService.selectTGasAlarmById(id));
    }

    /**
     * 新增报警器报警记录
     */
    @PreAuthorize("@ss.hasPermi('gas:alarm:add')")
    @Log(title = "报警器报警记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasAlarm tGasAlarm)
    {
        return toAjax(tGasAlarmService.insertTGasAlarm(tGasAlarm));
    }

    /**
     * 修改报警器报警记录
     */
    @PreAuthorize("@ss.hasPermi('gas:alarm:edit')")
    @Log(title = "报警器报警记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasAlarm tGasAlarm)
    {
        return toAjax(tGasAlarmService.updateTGasAlarm(tGasAlarm));
    }

    /**
     * 删除报警器报警记录
     */
    @PreAuthorize("@ss.hasPermi('gas:alarm:remove')")
    @Log(title = "报警器报警记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tGasAlarmService.deleteTGasAlarmByIds(ids));
    }

    /**
     * 获取缓存中报警信息
     * @return
     */
    @GetMapping("/getCacheAlarmInfo")
    public AjaxResult getCacheAlarmInfo(){
        return AjaxResult.success(tGasAlarmService.getCacheAlarmInfo());
    }
}
