package com.zehong.web.controller.cycle;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TDevInspect;
import com.zehong.system.domain.TDevLifeCycle;
import com.zehong.system.service.ITDevInspectService;
import com.zehong.system.service.ITDevLifeCycleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 设备台账Controller
 * 
 * @author zehong
 * @date 2023-12-12
 */
@RestController
@RequestMapping("/system/cycle")
public class TDevLifeCycleController extends BaseController
{
    @Autowired
    private ITDevLifeCycleService tDevLifeCycleService;
    @Autowired
    private ITDevInspectService tDevInspectService;
    /**
     * 查询设备台账列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TDevLifeCycle tDevLifeCycle)
    {
        startPage();
        List<TDevLifeCycle> list = tDevLifeCycleService.selectTDevLifeCycleList(tDevLifeCycle);
        return getDataTable(list);
    }
    @GetMapping("/listByParam")
    public TableDataInfo listByParam(TDevLifeCycle tDevLifeCycle)
    {
        startPage();
        List<TDevLifeCycle> list = tDevLifeCycleService.selectTDevLifeCycleListByParam(tDevLifeCycle);
        return getDataTable(list);
    }


    /**
     * 临检设备
     * @param tDevLifeCycle 参数
     * @return
     */
    @GetMapping("/closeInspectDevice")
    public AjaxResult closeInspectDevice(TDevLifeCycle tDevLifeCycle){
        List<TDevLifeCycle> list = tDevLifeCycleService.closeInspectDevice(tDevLifeCycle);
        return AjaxResult.success(list);
    }

    /**
     * 导出设备台账列表
     */
    @Log(title = "设备台账", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDevLifeCycle tDevLifeCycle)
    {
        List<TDevLifeCycle> list = tDevLifeCycleService.selectTDevLifeCycleList(tDevLifeCycle);
        ExcelUtil<TDevLifeCycle> util = new ExcelUtil<TDevLifeCycle>(TDevLifeCycle.class);
        return util.exportExcel(list, "设备台账数据");
    }

    /**
     * 获取设备台账详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDevLifeCycleService.selectTDevLifeCycleById(id));
    }

    /**
     * 新增设备台账
     */
    @Log(title = "设备台账", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDevLifeCycle tDevLifeCycle)
    {
        return toAjax(tDevLifeCycleService.insertTDevLifeCycle(tDevLifeCycle));
    }

    /**
     * 新增维修/保养记录
     * @param
     * @return
     */
    @Log(title = "设备保养/维修记录", businessType = BusinessType.INSERT)
    @PostMapping("/inspect")
    public AjaxResult addInspect(@RequestBody TDevInspect tDevInspect)
    {
        TDevLifeCycle tDevLifeCycle =new TDevLifeCycle();
        tDevLifeCycle.setId(tDevInspect.getDevLifeId());
        tDevLifeCycle.setCurrOverhaulDate(tDevInspect.getCurrDate());
        tDevLifeCycle.setNextOverhaulDate(tDevInspect.getNextDate());
        if("9".equals(tDevInspect.getInsType().toString())){//报废操作
            tDevLifeCycle.setDevStatus("9");
        }
        tDevLifeCycleService.updateTDevLifeCycle(tDevLifeCycle);
        return toAjax(tDevInspectService.insertTDevInspect(tDevInspect));
    }

    @GetMapping("/inspect/list")
    public TableDataInfo list(TDevInspect tDevInspect)
    {
        startPage();
        List<TDevInspect> list = tDevInspectService.selectTDevInspectList(tDevInspect);
        return getDataTable(list);
    }

    /**
     * 修改设备台账
     */
    @Log(title = "设备台账", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDevLifeCycle tDevLifeCycle)
    {
        return toAjax(tDevLifeCycleService.updateTDevLifeCycle(tDevLifeCycle));
    }

    /**
     * 删除设备台账
     */
    @Log(title = "设备台账", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDevLifeCycleService.deleteTDevLifeCycleByIds(ids));
    }

    /**
     * 设备类型统计
     * @return
     */
    @GetMapping("/devLifeStatistic")
    public AjaxResult devLifeStatistic(){
        return AjaxResult.success(tDevLifeCycleService.devLifeStatistic());
    }

    /**
     * 批量新增检查单
     * @return
     */
    @PostMapping("/batchAddInspect")
    public AjaxResult batchAddInspect(@RequestBody TDevInspect tDevInspect){
        return toAjax(tDevLifeCycleService.batchAddInspect(tDevInspect));
    }
}
