package com.zehong.web.controller.checktask;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDangerStatus;
import com.zehong.system.service.ITDangerStatusService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 隐患状态记录Controller
 * 
 * @author zehong
 * @date 2023-12-01
 */
@RestController
@RequestMapping("/danger/status")
public class TDangerStatusController extends BaseController
{
    @Autowired
    private ITDangerStatusService tDangerStatusService;

    /**
     * 查询隐患状态记录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:status:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDangerStatus tDangerStatus)
    {
        startPage();
        List<TDangerStatus> list = tDangerStatusService.selectTDangerStatusList(tDangerStatus);
        return getDataTable(list);
    }

    @GetMapping("/dangerStatusList")
    public AjaxResult dangerStatusList(TDangerStatus tDangerStatus){
        List<TDangerStatus> list = tDangerStatusService.selectTDangerStatusList(tDangerStatus);
        return AjaxResult.success(list);
    }

    /**
     * 导出隐患状态记录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:status:export')")
    @Log(title = "隐患状态记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDangerStatus tDangerStatus)
    {
        List<TDangerStatus> list = tDangerStatusService.selectTDangerStatusList(tDangerStatus);
        ExcelUtil<TDangerStatus> util = new ExcelUtil<TDangerStatus>(TDangerStatus.class);
        return util.exportExcel(list, "隐患状态记录数据");
    }

    /**
     * 获取隐患状态记录详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:status:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDangerStatusService.selectTDangerStatusById(id));
    }

    /**
     * 新增隐患状态记录
     */
    //@PreAuthorize("@ss.hasPermi('system:status:add')")
    @Log(title = "隐患状态记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDangerStatus tDangerStatus)
    {
        return toAjax(tDangerStatusService.insertTDangerStatus(tDangerStatus));
    }

    /**
     * 修改隐患状态记录
     */
    //@PreAuthorize("@ss.hasPermi('system:status:edit')")
    @Log(title = "隐患状态记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDangerStatus tDangerStatus)
    {
        return toAjax(tDangerStatusService.updateTDangerStatus(tDangerStatus));
    }

    /**
     * 删除隐患状态记录
     */
    //@PreAuthorize("@ss.hasPermi('system:status:remove')")
    @Log(title = "隐患状态记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDangerStatusService.deleteTDangerStatusByIds(ids));
    }
}
