import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listGps(query) {
  return request({
    url: '/user/gps/list',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getGps(id) {
  return request({
    url: '/user/gps/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addGps(data) {
  return request({
    url: '/user/gps',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateGps(data) {
  return request({
    url: '/user/gps',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delGps(id) {
  return request({
    url: '/user/gps/' + id,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportGps(query) {
  return request({
    url: '/user/gps/export',
    method: 'get',
    params: query
  })
}


//获取当前位置
export function getCurrentLocation(query) {
  return request({
    url: '/user/gps/getCurrentLocation',
    method: 'get',
    params: query
  })
}

//获取历史轨迹
export function historyTrack(query) {
  return request({
    url: '/user/gps/historyTrack',
    method: 'get',
    params: query
  })
}
