import request from '@/utils/request'

// 查询设备巡检任务列表
export function listTask(query) {
  return request({
    url: '/device/task/list',
    method: 'get',
    params: query
  })
}

// 查询设备巡检任务详细
export function getTask(id) {
  return request({
    url: '/device/task/' + id,
    method: 'get'
  })
}

// 新增设备巡检任务
export function addTask(data) {
  return request({
    url: '/device/task',
    method: 'post',
    data: data
  })
}

// 修改设备巡检任务
export function updateTask(data) {
  return request({
    url: '/device/task',
    method: 'put',
    data: data
  })
}

// 删除设备巡检任务
export function delTask(id) {
  return request({
    url: '/device/task/' + id,
    method: 'delete'
  })
}

// 导出设备巡检任务
export function exportTask(query) {
  return request({
    url: '/device/task/export',
    method: 'get',
    params: query
  })
}
