import request from '@/utils/request'

// 查询组内成员信息列表
export function listInfo(query) {
  return request({
    url: '/group/info/list',
    method: 'get',
    params: query
  })
}

// 查询组内成员信息详细
export function getInfo(memberId) {
  return request({
    url: '/group/info/' + memberId,
    method: 'get'
  })
}

// 新增组内成员信息
export function addInfo(data) {
  return request({
    url: '/group/info',
    method: 'post',
    data: data
  })
}

// 修改组内成员信息
export function updateInfo(data) {
  return request({
    url: '/group/info',
    method: 'put',
    data: data
  })
}

// 删除组内成员信息
export function delInfo(memberId) {
  return request({
    url: '/group/info/' + memberId,
    method: 'delete'
  })
}

// 导出组内成员信息
export function exportInfo(query) {
  return request({
    url: '/group/info/export',
    method: 'get',
    params: query
  })
}

//获取人员信息
export function selectMemberInfo(data) {
  return request({
    url: '/group/member/selectMemberInfo',
    method: 'post',
    data: data
  })
}
