import request from '@/utils/request'

// 查询工业用户列表
export function listIndustry(query) {
  return request({
    url: '/baseinfo/industry/list',
    method: 'get',
    params: query
  })
}

// 查询工业用户详细
export function getIndustry(id) {
  return request({
    url: '/baseinfo/industry/' + id,
    method: 'get'
  })
}

// 新增工业用户
export function addIndustry(data) {
  return request({
    url: '/baseinfo/industry',
    method: 'post',
    data: data
  })
}

// 修改工业用户
export function updateIndustry(data) {
  return request({
    url: '/baseinfo/industry',
    method: 'put',
    data: data
  })
}

// 删除工业用户
export function delIndustry(id) {
  return request({
    url: '/baseinfo/industry/' + id,
    method: 'delete'
  })
}

// 导出工业用户
export function exportIndustry(query) {
  return request({
    url: '/baseinfo/industry/export',
    method: 'get',
    params: query
  })
}

//工业用户入户安检信息查询
export function getIndustryInspectInfo(query) {
  return request({
    url: '/baseinfo/industry/getIndustryInspectInfo',
    method: 'get',
    params: query
  })
}
