import request from '@/utils/request'

// 查询居民小区（村）列表
export function listCommunity(query) {
  return request({
    url: '/system/community/list',
    method: 'get',
    params: query
  })
}

// 查询居民小区（村）详细
export function getCommunity(id) {
  return request({
    url: '/system/community/' + id,
    method: 'get'
  })
}

// 新增居民小区（村）
export function addCommunity(data) {
  return request({
    url: '/system/community',
    method: 'post',
    data: data
  })
}

// 修改居民小区（村）
export function updateCommunity(data) {
  return request({
    url: '/system/community',
    method: 'put',
    data: data
  })
}

// 删除居民小区（村）
export function delCommunity(id) {
  return request({
    url: '/system/community/' + id,
    method: 'delete'
  })
}

// 导出居民小区（村）
export function exportCommunity(query) {
  return request({
    url: '/system/community/export',
    method: 'get',
    params: query
  })
}

//小区列表不带分页
export function communityList(query) {
  return request({
    url: '/system/community/communityList',
    method: 'get',
    params: query
  })
}
