package com.zehong.system.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TDanger;
import com.zehong.system.domain.TPipeUser;
import com.zehong.system.mapper.TDangerMapper;
import com.zehong.system.mapper.TPipeInfoMapper;
import com.zehong.system.mapper.TPipeUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPipeTaskInspectMapper;
import com.zehong.system.domain.TPipeTaskInspect;
import com.zehong.system.service.ITPipeTaskInspectService;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 管线巡线任务执行Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-17
 */
@Service
public class TPipeTaskInspectServiceImpl implements ITPipeTaskInspectService 
{
    @Autowired
    private TPipeTaskInspectMapper tPipeTaskInspectMapper;
    @Autowired
    private TDangerMapper tDangerMapper;
    @Resource
    private TPipeUserMapper tPipeUserMapper;
    @Resource
    private TPipeInfoMapper tPipeInfoMapper;

    /**
     * 查询管线巡线任务执行
     * 
     * @param id 管线巡线任务执行ID
     * @return 管线巡线任务执行
     */
    @Override
    public TPipeTaskInspect selectTPipeTaskInspectById(Long id)
    {
        return tPipeTaskInspectMapper.selectTPipeTaskInspectById(id);
    }

    /**
     * 查询管线巡线任务执行列表
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行
     */
    @Override
    public List<TPipeTaskInspect> selectTPipeTaskInspectList(TPipeTaskInspect tPipeTaskInspect)
    {
        return tPipeTaskInspectMapper.selectTPipeTaskInspectList(tPipeTaskInspect);
    }

    /**
     * 打卡点排序
     * @param tPipeTaskInspect
     * @return
     */
    @Override
    public List<TPipeTaskInspect> selectPipeDistance(TPipeTaskInspect tPipeTaskInspect)
    {
        return tPipeTaskInspectMapper.selectPipeDistance(tPipeTaskInspect);
    }

    /**
     * 新增管线巡线任务执行
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 结果
     */
    @Override
    public int insertTPipeTaskInspect(TPipeTaskInspect tPipeTaskInspect)
    {
        tPipeTaskInspect.setCreateTime(DateUtils.getNowDate());
        return tPipeTaskInspectMapper.insertTPipeTaskInspect(tPipeTaskInspect);
    }

    /**
     * 修改管线巡线任务执行
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 结果
     */
    @Override
    public int updateTPipeTaskInspect(TPipeTaskInspect tPipeTaskInspect)
    {
        tPipeTaskInspect.setCreateTime(new Date());
        if(tPipeTaskInspect.getStatus()==1){
            tDangerMapper.updateByInspect(tPipeTaskInspect.getId(),4);
        }
        return tPipeTaskInspectMapper.updateTPipeTaskInspect(tPipeTaskInspect);
    }

    /**
     * 批量删除管线巡线任务执行
     * 
     * @param ids 需要删除的管线巡线任务执行ID
     * @return 结果
     */
    @Override
    public int deleteTPipeTaskInspectByIds(Long[] ids)
    {
        return tPipeTaskInspectMapper.deleteTPipeTaskInspectByIds(ids);
    }

    /**
     * 删除管线巡线任务执行信息
     * 
     * @param id 管线巡线任务执行ID
     * @return 结果
     */
    @Override
    public int deleteTPipeTaskInspectById(Long id)
    {
        return tPipeTaskInspectMapper.deleteTPipeTaskInspectById(id);
    }

    /**
     * 查询管线及打卡点信息
     * @param tPipeTaskInspect
     * @return
     */
    @Override
    public Map<String,Object> selectPipeAndPointInspectInfo(TPipeTaskInspect tPipeTaskInspect){
        Map<String,Object> result = new HashMap<>();
        if(null != tPipeTaskInspect.getUserId()){
            TPipeUser tPipeUser = new TPipeUser();
            tPipeUser.setUserId(tPipeTaskInspect.getUserId());
            result.put("pipeInfo",tPipeUserMapper.selectUserPipeInfo(tPipeUser));
        }
        if(null != tPipeTaskInspect.getPipeId()){
            result.put("pipeInfo",tPipeInfoMapper.selectTPipeInfoById(tPipeTaskInspect.getPipeId()));
        }
        result.put("pointInfo",tPipeTaskInspectMapper.selectTPipeTaskPointInspectList(tPipeTaskInspect));
        return result;
    }


    /**
     * 一天多检 20241223
     * @param tPipeTaskInspect
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int moreDailyInspect(TPipeTaskInspect tPipeTaskInspect){
        //多检获取之前安检信息新增安检记录
        TPipeTaskInspect inspectInfo = tPipeTaskInspectMapper.selectTPipeTaskInspectById(tPipeTaskInspect.getId());
        tPipeTaskInspect.setTaskId(inspectInfo.getTaskId());
        tPipeTaskInspect.setUserId(inspectInfo.getUserId());
        tPipeTaskInspect.setPoint(inspectInfo.getPoint());
        tPipeTaskInspect.setCreateTime(DateUtils.getNowDate());
        int result = tPipeTaskInspectMapper.insertTPipeTaskInspect(tPipeTaskInspect);
        //存在异常更新隐患信息
        if(StringUtils.isNotEmpty(tPipeTaskInspect.getContent())){
            JSONObject content = JSON.parseObject(tPipeTaskInspect.getContent());
            for(String key : content.keySet()){
                JSONObject detail = content.getJSONObject(key);
                if(StringUtils.isNotEmpty(detail.getString("dangerId"))){
                    TDanger danger = new TDanger();
                    danger.setId(Long.valueOf(detail.getString("dangerId")));
                    danger.setInspectId(tPipeTaskInspect.getId());
                    danger.setStatus(Integer.valueOf("0"));
                    tDangerMapper.updateTDanger(danger);
                }
            }
        }
        return result;
    }


    /**
     * 查询管线巡线任务打卡点执行列表
     *
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行集合
     */
    public List<TPipeTaskInspect> selectTPipeTaskPointInspectList(TPipeTaskInspect tPipeTaskInspect){
        return tPipeTaskInspectMapper.selectTPipeTaskPointInspectList(tPipeTaskInspect);
    }
}
