package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TGroupMemberInfoMapper;
import com.zehong.system.domain.TGroupMemberInfo;
import com.zehong.system.service.ITGroupMemberInfoService;

/**
 * 组内成员信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-12-05
 */
@Service
public class TGroupMemberInfoServiceImpl implements ITGroupMemberInfoService 
{
    @Autowired
    private TGroupMemberInfoMapper tGroupMemberInfoMapper;

    /**
     * 查询组内成员信息
     * 
     * @param memberId 组内成员信息ID
     * @return 组内成员信息
     */
    @Override
    public TGroupMemberInfo selectTGroupMemberInfoById(Long memberId)
    {
        return tGroupMemberInfoMapper.selectTGroupMemberInfoById(memberId);
    }

    /**
     * 查询组内成员信息列表
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 组内成员信息
     */
    @Override
    public List<TGroupMemberInfo> selectTGroupMemberInfoList(TGroupMemberInfo tGroupMemberInfo)
    {
        return tGroupMemberInfoMapper.selectTGroupMemberInfoList(tGroupMemberInfo);
    }

    /**
     * 新增组内成员信息
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 结果
     */
    @Override
    public int insertTGroupMemberInfo(TGroupMemberInfo tGroupMemberInfo)
    {
        tGroupMemberInfo.setCreateTime(DateUtils.getNowDate());
        return tGroupMemberInfoMapper.insertTGroupMemberInfo(tGroupMemberInfo);
    }

    /**
     * 修改组内成员信息
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 结果
     */
    @Override
    public int updateTGroupMemberInfo(TGroupMemberInfo tGroupMemberInfo)
    {
        tGroupMemberInfo.setUpdateTime(DateUtils.getNowDate());
        return tGroupMemberInfoMapper.updateTGroupMemberInfo(tGroupMemberInfo);
    }

    /**
     * 批量删除组内成员信息
     * 
     * @param memberIds 需要删除的组内成员信息ID
     * @return 结果
     */
    @Override
    public int deleteTGroupMemberInfoByIds(Long[] memberIds)
    {
        return tGroupMemberInfoMapper.deleteTGroupMemberInfoByIds(memberIds);
    }

    /**
     * 删除组内成员信息信息
     * 
     * @param memberId 组内成员信息ID
     * @return 结果
     */
    @Override
    public int deleteTGroupMemberInfoById(Long memberId)
    {
        return tGroupMemberInfoMapper.deleteTGroupMemberInfoById(memberId);
    }


    /**
     * 获取人员信息
     * @return
     */
    @Override
    public List<Map<String,Object>> selectMemberInfo(Map<String,Object> map){
        return tGroupMemberInfoMapper.selectMemberInfo(map);
    }
}
