package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceTaskMapper;
import com.zehong.system.domain.TDeviceTask;
import com.zehong.system.service.ITDeviceTaskService;

/**
 * 设备巡检任务Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-11
 */
@Service
public class TDeviceTaskServiceImpl implements ITDeviceTaskService 
{
    @Autowired
    private TDeviceTaskMapper tDeviceTaskMapper;

    /**
     * 查询设备巡检任务
     * 
     * @param id 设备巡检任务ID
     * @return 设备巡检任务
     */
    @Override
    public TDeviceTask selectTDeviceTaskById(Long id)
    {
        return tDeviceTaskMapper.selectTDeviceTaskById(id);
    }

    /**
     * 查询设备巡检任务列表
     * 
     * @param tDeviceTask 设备巡检任务
     * @return 设备巡检任务
     */
    @Override
    public List<TDeviceTask> selectTDeviceTaskList(TDeviceTask tDeviceTask)
    {
        return tDeviceTaskMapper.selectTDeviceTaskList(tDeviceTask);
    }

    /**
     * 小程序任务列表
     * @param tDeviceTask
     * @return
     */
    @Override
    public List<TDeviceTask> selectTDeviceTaskNum(TDeviceTask tDeviceTask)
    {
        return tDeviceTaskMapper.selectTDeviceTaskNum(tDeviceTask);
    }
    /**
     * 新增设备巡检任务
     * 
     * @param tDeviceTask 设备巡检任务
     * @return 结果
     */
    @Override
    public int insertTDeviceTask(TDeviceTask tDeviceTask)
    {
        tDeviceTask.setCreateTime(DateUtils.getNowDate());
        tDeviceTask.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
        return tDeviceTaskMapper.insertTDeviceTask(tDeviceTask);
    }

    /**
     * 修改设备巡检任务
     * 
     * @param tDeviceTask 设备巡检任务
     * @return 结果
     */
    @Override
    public int updateTDeviceTask(TDeviceTask tDeviceTask)
    {
        return tDeviceTaskMapper.updateTDeviceTask(tDeviceTask);
    }

    /**
     * 批量删除设备巡检任务
     * 
     * @param ids 需要删除的设备巡检任务ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceTaskByIds(Long[] ids)
    {
        return tDeviceTaskMapper.deleteTDeviceTaskByIds(ids);
    }

    /**
     * 删除设备巡检任务信息
     * 
     * @param id 设备巡检任务ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceTaskById(Long id)
    {
        return tDeviceTaskMapper.deleteTDeviceTaskById(id);
    }
}
