package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TGroupMemberInfo;

/**
 * 组内成员信息Mapper接口
 * 
 * @author zehong
 * @date 2025-12-05
 */
public interface TGroupMemberInfoMapper 
{
    /**
     * 查询组内成员信息
     * 
     * @param memberId 组内成员信息ID
     * @return 组内成员信息
     */
    public TGroupMemberInfo selectTGroupMemberInfoById(Long memberId);

    /**
     * 查询组内成员信息列表
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 组内成员信息集合
     */
    public List<TGroupMemberInfo> selectTGroupMemberInfoList(TGroupMemberInfo tGroupMemberInfo);

    /**
     * 新增组内成员信息
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 结果
     */
    public int insertTGroupMemberInfo(TGroupMemberInfo tGroupMemberInfo);

    /**
     * 修改组内成员信息
     * 
     * @param tGroupMemberInfo 组内成员信息
     * @return 结果
     */
    public int updateTGroupMemberInfo(TGroupMemberInfo tGroupMemberInfo);

    /**
     * 删除组内成员信息
     * 
     * @param memberId 组内成员信息ID
     * @return 结果
     */
    public int deleteTGroupMemberInfoById(Long memberId);

    /**
     * 批量删除组内成员信息
     * 
     * @param memberIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTGroupMemberInfoByIds(Long[] memberIds);

    /**
     * 获取人员信息
     * @return
     */
    List<Map<String,Object>> selectMemberInfo(Map<String,Object> map);

    int deleteTGroupMemberInfoByGroupId(Long groupId);
}
