package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

import java.math.BigDecimal;

/**
 * 安检任务执行对象 t_task_inspect
 * 
 * @author zehong
 * @date 2023-11-07
 */
public class TTaskInspect extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 任务id */
    @Excel(name = "任务id")
    private Long taskId;

    private String meterImg;


    /** 经度 */
    @Excel(name = "经度")
    private BigDecimal longitude;

    /** 纬度 */
    @Excel(name = "纬度")
    private BigDecimal latitude;

    /** 检查单json */
    @Excel(name = "检查单json")
    private String content;

    /** 安检人id */
    @Excel(name = "安检人id")
    private Long memberId;

    /** 用户类型，1是居民，2是工商户，3是工业 */
    @Excel(name = "用户类型，1是居民，2是工商户，3是工业")
    private Long type;

    /** 居民，工商户，工业id */
    @Excel(name = "居民，工商户，工业id")
    private Long receiveId;

    /** 0未检测 1有隐患，2整改完成，3完结 */
    @Excel(name = "0未检测 1有隐患，2整改完成，3完结")
    private Long status;

    /** 满意度，1是不满意，2是一般，3是满意 */
    @Excel(name = "满意度，1是不满意，2是一般，3是满意")
    private Long satisfy;

    /** 签字，0是未签字，1是已签字 */
    @Excel(name = "签字，0是未签字，1是已签字")
    private Long sign;

    /** 是否有隐患，0没有，1有 */
    private Integer danger;

    /** 表底数据 */
    @Excel(name = "表底数据")
    private String meterData;

    private String memberName;

    private String receiveName;

    private String usernum;
    private String username;
    private String phone;

    /** 工业安检类型 1月度巡检 2季度巡检 */
    private Long checkType;

    //统计年月
    private String dateBegin;

    private String dateEnd;
    //任务类型
    private String taskType;

    public String getMeterImg() {
        return meterImg;
    }

    public void setMeterImg(String meterImg) {
        this.meterImg = meterImg;
    }

    public String getUsernum() {
        return usernum;
    }

    public void setUsernum(String usernum) {
        this.usernum = usernum;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }
    public void setLongitude(BigDecimal longitude)
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude()
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude)
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude()
    {
        return latitude;
    }
    public void setContent(String content) 
    {
        this.content = content;
    }

    public String getContent() 
    {
        return content;
    }
    public void setMemberId(Long memberId) 
    {
        this.memberId = memberId;
    }

    public Long getMemberId() 
    {
        return memberId;
    }
    public void setType(Long type) 
    {
        this.type = type;
    }

    public Long getType() 
    {
        return type;
    }
    public void setReceiveId(Long receiveId) 
    {
        this.receiveId = receiveId;
    }

    public Long getReceiveId() 
    {
        return receiveId;
    }
    public void setStatus(Long status) 
    {
        this.status = status;
    }

    public Long getStatus() 
    {
        return status;
    }
    public void setSatisfy(Long satisfy) 
    {
        this.satisfy = satisfy;
    }

    public Long getSatisfy() 
    {
        return satisfy;
    }
    public void setSign(Long sign) 
    {
        this.sign = sign;
    }

    public Long getSign() 
    {
        return sign;
    }
    public void setMeterData(String meterData) 
    {
        this.meterData = meterData;
    }

    public Integer getDanger() {
        return danger;
    }

    public void setDanger(Integer danger) {
        this.danger = danger;
    }

    public String getMeterData()
    {
        return meterData;
    }

    public String getMemberName() {
        return memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public String getReceiveName() {
        return receiveName;
    }

    public void setReceiveName(String receiveName) {
        this.receiveName = receiveName;
    }

    public Long getCheckType() {
        return checkType;
    }

    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    public String getDateBegin() {
        return dateBegin;
    }

    public void setDateBegin(String dateBegin) {
        this.dateBegin = dateBegin;
    }

    public String getDateEnd() {
        return dateEnd;
    }

    public void setDateEnd(String dateEnd) {
        this.dateEnd = dateEnd;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("taskId", getTaskId())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("content", getContent())
            .append("memberId", getMemberId())
            .append("type", getType())
            .append("receiveId", getReceiveId())
            .append("status", getStatus())
            .append("satisfy", getSatisfy())
            .append("sign", getSign())
            .append("createTime", getCreateTime())
            .append("meterData", getMeterData())
            .toString();
    }
}
