package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 入户安检任务对象 t_task
 * 
 * @author zehong
 * @date 2023-11-06
 */
public class TTask extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 任务名称 */
    @Excel(name = "任务名称")
    private String title;

    /** 任务描述 */
    @Excel(name = "任务描述")
    private String describe;

    /** 用户类型，1是居民，2是工商户，3是工业 */
    @Excel(name = "用户类型",readConverterExp = "1=居民,2=工商户,3=工业")
    private Long type;

    /** 工业安检类型 1月度巡检 2季度巡检 */
    @Excel(name = "工业安检类型",readConverterExp = "1=月度巡检,2=季度巡检" )
    private Long checkType;

    /** 安检类型，1小区用户，2气代煤用户，3孤寡老人用户 */
    @Excel(name = "安检类型",dictType = "t_inspect_user_type")
    private String taskType;

    /** 开始日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 任务状态 0进行中 1已结束 */
    @Excel(name = "任务状态",readConverterExp = "0=进行中,1=已结束")
    private Long status;

    /** 创建人 */
    private Long adminId;

    @Excel(name = "创建人")
    private String nickname;

    /** 备注 */
    @Excel(name = "备注")
    private String remarks;

    private String inspcetTotal;

    private Integer isjian;

    private Integer allnum;

    private String year;

    //当前登录人安检数  2024-05-28需求要求
    private Integer selfInspectNum;


    public Integer getIsjian() {
        return isjian;
    }

    public void setIsjian(Integer isjian) {
        this.isjian = isjian;
    }

    public Integer getAllnum() {
        return allnum;
    }

    public void setAllnum(Integer allnum) {
        this.allnum = allnum;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setTitle(String title) 
    {
        this.title = title;
    }

    public String getTitle() 
    {
        return title;
    }
    public void setDescribe(String describe) 
    {
        this.describe = describe;
    }

    public String getDescribe() 
    {
        return describe;
    }
    public void setType(Long type) 
    {
        this.type = type;
    }

    public Long getType() 
    {
        return type;
    }
    public void setCheckType(Long checkType) 
    {
        this.checkType = checkType;
    }

    public Long getCheckType() 
    {
        return checkType;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public void setStartTime(Date startTime)
    {
        this.startTime = startTime;
    }

    public Date getStartTime() 
    {
        return startTime;
    }
    public void setEndTime(Date endTime) 
    {
        this.endTime = endTime;
    }

    public Date getEndTime() 
    {
        return endTime;
    }
    public void setStatus(Long status) 
    {
        this.status = status;
    }

    public Long getStatus() 
    {
        return status;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    public String getInspcetTotal() {
        return inspcetTotal;
    }

    public void setInspcetTotal(String inspcetTotal) {
        this.inspcetTotal = inspcetTotal;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public Integer getSelfInspectNum() {
        return selfInspectNum;
    }

    public void setSelfInspectNum(Integer selfInspectNum) {
        this.selfInspectNum = selfInspectNum;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("title", getTitle())
            .append("describe", getDescribe())
            .append("type", getType())
            .append("checkType", getCheckType())
            .append("startTime", getStartTime())
            .append("endTime", getEndTime())
            .append("status", getStatus())
            .append("adminId", getAdminId())
            .append("createTime", getCreateTime())
            .append("remarks", getRemarks())
            .toString();
    }
}
