package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * 居民安检项统计信息对象 t_inspect_statistics_info
 * 
 * @author zehong
 * @date 2025-09-11
 */
public class TInspectStatisticsInfo implements Cloneable {

    /** 主键id */
    private Long statisticsId;

    /** 名称 */
    @Excel(name = "名称")
    private String name;

    /** 名称哈希值 */
    @Excel(name = "名称哈希值")
    private int nameHashCode;

    /** 隐患数量 */
    @Excel(name = "隐患数量")
    private Integer dangerNum;

    /** 安检类型，1小区用户，2气代煤用户，3孤寡老人用户 */
    @Excel(name = "安检类型，1小区用户，2气代煤用户，3孤寡老人用户")
    private String taskType;

    /** 用户总数 */
    @Excel(name = "用户总数")
    private Integer userNum;

    /** 用户隐患总数 */
    @Excel(name = "用户隐患总数")
    private Integer userDangerNum;

    /** 安检总数 */
    @Excel(name = "安检总数")
    private Integer inspectNum;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    private Integer sort;

    private String dateBegin;

    private String dateEnd;

    public void setStatisticsId(Long statisticsId) 
    {
        this.statisticsId = statisticsId;
    }

    public Long getStatisticsId() 
    {
        return statisticsId;
    }
    public void setName(String name) 
    {
        this.name = name;
    }

    public String getName() 
    {
        return name;
    }
    public void setNameHashCode(int nameHashCode)
    {
        this.nameHashCode = nameHashCode;
    }

    public int getNameHashCode()
    {
        return nameHashCode;
    }
    public void setDangerNum(Integer dangerNum) 
    {
        this.dangerNum = dangerNum;
    }

    public Integer getDangerNum() 
    {
        return dangerNum;
    }
    public void setTaskType(String taskType) 
    {
        this.taskType = taskType;
    }

    public String getTaskType() 
    {
        return taskType;
    }
    public void setUserNum(Integer userNum) 
    {
        this.userNum = userNum;
    }

    public Integer getUserNum() 
    {
        return userNum;
    }
    public void setUserDangerNum(Integer userDangerNum) 
    {
        this.userDangerNum = userDangerNum;
    }

    public Integer getUserDangerNum() 
    {
        return userDangerNum;
    }
    public void setInspectNum(Integer inspectNum) 
    {
        this.inspectNum = inspectNum;
    }

    public Integer getInspectNum() 
    {
        return inspectNum;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getDateBegin() {
        return dateBegin;
    }

    public void setDateBegin(String dateBegin) {
        this.dateBegin = dateBegin;
    }

    public String getDateEnd() {
        return dateEnd;
    }

    public void setDateEnd(String dateEnd) {
        this.dateEnd = dateEnd;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("statisticsId", getStatisticsId())
            .append("name", getName())
            .append("nameHashCode", getNameHashCode())
            .append("dangerNum", getDangerNum())
            .append("taskType", getTaskType())
            .append("userNum", getUserNum())
            .append("userDangerNum", getUserDangerNum())
            .append("inspectNum", getInspectNum())
            .append("createTime", getCreateTime())
            .toString();
    }
}
