package com.zehong.web.controller.checktask;

import java.util.List;
import java.util.stream.Collectors;

import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TDanger;
import com.zehong.system.service.ITDangerService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 安检隐患整改Controller
 * 
 * @author zehong
 * @date 2023-11-09
 */
@RestController
@RequestMapping("/checkTask/danger")
public class TDangerController extends BaseController
{
    @Autowired
    private ITDangerService tDangerService;

    /**
     * 查询安检隐患整改列表
     */
   // @PreAuthorize("@ss.hasPermi('checkTask:danger:list')")
    @GetMapping("/list")
    public TableDataInfo list(TDanger tDanger)
    {
        startPage();
        List<SysRole> visitor = SecurityUtils.getLoginUser().getUser().getRoles().stream().filter(item ->"visitor".equals(item.getRoleKey())).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(visitor)){
            tDanger.setIsVisitor("1");
        }
        List<TDanger> list = tDangerService.selectTDangerList(tDanger);
        return getDataTable(list);
    }

    @GetMapping("/dangerInfoList")
    public TableDataInfo dangerInfoList(TDanger tDanger){
        startPage();
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //客服运营部
        if(200 == user.getDeptId()){
            tDanger.setAdminId(user.getUserId().intValue());
            tDanger.setFlag(2);
        }
        //生产运营部
        if(102 == user.getDeptId()){
            tDanger.setAdminId(user.getUserId().intValue());
            tDanger.setFlag(3);
        }

        //205 安全管理部
        if(205 != user.getDeptId() && 200 != user.getDeptId() && 102 != user.getDeptId()){
            tDanger.setAdminId(user.getUserId().intValue());
        }
        List<TDanger> list = tDangerService.selectTDangerList(tDanger);
        return getDataTable(list);
    }

    /**
     * 导出安检隐患整改列表
     */
   // @PreAuthorize("@ss.hasPermi('checkTask:danger:export')")
    @Log(title = "安检隐患整改", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TDanger tDanger)
    {
        List<SysRole> visitor = SecurityUtils.getLoginUser().getUser().getRoles().stream().filter(item ->"visitor".equals(item.getRoleKey())).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(visitor)){
            tDanger.setIsVisitor("1");
        }
        List<TDanger> list = tDangerService.selectTDangerList(tDanger);
        ExcelUtil<TDanger> util = new ExcelUtil<TDanger>(TDanger.class);
        return util.exportExcel(list, "安检隐患整改数据");
    }

    /**
     * 获取安检隐患整改详细信息
     */
    //@PreAuthorize("@ss.hasPermi('checkTask:danger:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tDangerService.selectTDangerById(id));
    }

    /**
     * 新增安检隐患整改
     */
   // @PreAuthorize("@ss.hasPermi('checkTask:danger:add')")
    @Log(title = "安检隐患整改", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TDanger tDanger)
    {
        Integer a = tDangerService.insertTDanger(tDanger);
        return AjaxResult.success(tDanger.getId());
    }

    /**
     * 修改安检隐患整改
     */
    //@PreAuthorize("@ss.hasPermi('checkTask:danger:edit')")
    @Log(title = "安检隐患整改", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TDanger tDanger)
    {
        return toAjax(tDangerService.updateTDanger(tDanger));
    }

    /**
     * 删除安检隐患整改
     */
    //@PreAuthorize("@ss.hasPermi('checkTask:danger:remove')")
    @Log(title = "安检隐患整改", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tDangerService.deleteTDangerByIds(ids));
    }


    /**
     * 游客数据权限设置
     * @param isVisitor 游客是否可访问
     * @param ids 隐患主键
     * @return
     */
    @GetMapping("/dangerDataPermission")
    public AjaxResult dangerDataVisitorPermission(@RequestParam(value="isVisitor")String isVisitor,@RequestParam(value="ids")Long[] ids){
        return toAjax(tDangerService.dangerDataVisitorPermission(isVisitor,ids));
    }

}
