package com.zehong.web.controller.baseinfo;

import java.util.List;

import com.zehong.system.domain.TArea;
import com.zehong.system.service.ITAreaService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TBusiness;
import com.zehong.system.service.ITBusinessService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 工商业用户Controller
 * 
 * @author zehong
 * @date 2023-11-03
 */
@RestController
@RequestMapping("/baseInfo/business")
public class TBusinessController extends BaseController
{
    @Autowired
    private ITBusinessService tBusinessService;

    @Autowired
    private ITAreaService tAreaService;

    /**
     * 查询工商业用户列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:business:list')")
    @GetMapping("/list")
    public TableDataInfo list(TBusiness tBusiness)
    {
        startPage();
        List<TBusiness> list = tBusinessService.selectTBusinessList(tBusiness);
        return getDataTable(list);
    }

    /**
     * 导出工商业用户列表
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:business:export')")
    @Log(title = "工商业用户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TBusiness tBusiness)
    {
        List<TBusiness> list = tBusinessService.selectTBusinessList(tBusiness);
        for(TBusiness business : list){
            if(null != business.getCity()){
                TArea county = tAreaService.selectTAreaById(business.getCity());
                business.setCityName(null != county.getAreaName() ? county.getAreaName() : "");
            }
            if(null != business.getCounty()){
                TArea county = tAreaService.selectTAreaById(business.getCounty());
                business.setCountyName(null != county.getAreaName() ? county.getAreaName() : "");
            }
            if(null != business.getStreet()){
                TArea stree = tAreaService.selectTAreaById(business.getStreet());
                business.setStreetName(null !=stree ? stree.getAreaName() : "");
            }
        }
        ExcelUtil<TBusiness> util = new ExcelUtil<TBusiness>(TBusiness.class);
        return util.exportExcel(list, "工商业用户数据");
    }

    /**
     * 获取工商业用户详细信息
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:business:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tBusinessService.selectTBusinessById(id));
    }

    @GetMapping(value = "businessInfo/{id}")
    public AjaxResult getBusinessInfo(@PathVariable("id") Long id){
        return AjaxResult.success(tBusinessService.selectTBusinessById(id));
    }

    /**
     * 新增工商业用户
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:business:add')")
    @Log(title = "工商业用户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TBusiness tBusiness)
    {
        return toAjax(tBusinessService.insertTBusiness(tBusiness));
    }

    /**
     * 修改工商业用户
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:business:edit')")
    @Log(title = "工商业用户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TBusiness tBusiness)
    {
        return toAjax(tBusinessService.updateTBusiness(tBusiness));
    }

    /**
     * 删除工商业用户
     */
    //@PreAuthorize("@ss.hasPermi('baseInfo:business:remove')")
    @Log(title = "工商业用户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tBusinessService.deleteTBusinessByIds(ids));
    }
}
