import request from '@/utils/request'

// 查询管线巡线任务执行列表
export function listPipeinspect(query) {
  return request({
    url: '/pipetask/pipeinspect/list',
    method: 'get',
    params: query
  })
}

// 查询管线巡线任务执行详细
export function getPipeinspect(id) {
  return request({
    url: '/pipetask/pipeinspect/' + id,
    method: 'get'
  })
}

// 新增管线巡线任务执行
export function addPipeinspect(data) {
  return request({
    url: '/pipetask/pipeinspect',
    method: 'post',
    data: data
  })
}

// 修改管线巡线任务执行
export function updatePipeinspect(data) {
  return request({
    url: '/pipetask/pipeinspect',
    method: 'put',
    data: data
  })
}

// 删除管线巡线任务执行
export function delPipeinspect(id) {
  return request({
    url: '/pipetask/pipeinspect/' + id,
    method: 'delete'
  })
}

// 导出管线巡线任务执行
export function exportPipeinspect(query) {
  return request({
    url: '/pipetask/pipeinspect/export',
    method: 'get',
    params: query
  })
}

//获取管道及打卡点信息
export function selectPipeAndPointInspectInfo(query) {
  return request({
    url: '/pipetask/pipeinspect/selectPipeAndPointInspectInfo',
    method: 'get',
    params: query
  })
}

//查询管线巡线任务打卡点执行列表
export function selectTPipeTaskPointInspectList(query) {
  return request({
    url: '/pipetask/pipeinspect/selectTPipeTaskPointInspectList',
    method: 'get',
    params: query
  })
}
