package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TIndustryMapper;
import com.zehong.system.domain.TIndustry;
import com.zehong.system.service.ITIndustryService;

/**
 * 工业用户Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-04
 */
@Service
public class TIndustryServiceImpl implements ITIndustryService 
{
    @Autowired
    private TIndustryMapper tIndustryMapper;

    /**
     * 查询工业用户
     * 
     * @param id 工业用户ID
     * @return 工业用户
     */
    @Override
    public TIndustry selectTIndustryById(Long id)
    {
        return tIndustryMapper.selectTIndustryById(id);
    }

    /**
     * 查询工业用户列表
     * 
     * @param tIndustry 工业用户
     * @return 工业用户
     */
    @Override
    public List<TIndustry> selectTIndustryList(TIndustry tIndustry)
    {
        return tIndustryMapper.selectTIndustryList(tIndustry);
    }

    /**
     * 新增工业用户
     * 
     * @param tIndustry 工业用户
     * @return 结果
     */
    @Override
    public int insertTIndustry(TIndustry tIndustry)
    {
        tIndustry.setCreateTime(DateUtils.getNowDate());
        return tIndustryMapper.insertTIndustry(tIndustry);
    }

    /**
     * 修改工业用户
     * 
     * @param tIndustry 工业用户
     * @return 结果
     */
    @Override
    public int updateTIndustry(TIndustry tIndustry)
    {
        return tIndustryMapper.updateTIndustry(tIndustry);
    }

    /**
     * 批量删除工业用户
     * 
     * @param ids 需要删除的工业用户ID
     * @return 结果
     */
    @Override
    public int deleteTIndustryByIds(Long[] ids)
    {
        return tIndustryMapper.deleteTIndustryByIds(ids);
    }

    /**
     * 删除工业用户信息
     * 
     * @param id 工业用户ID
     * @return 结果
     */
    @Override
    public int deleteTIndustryById(Long id)
    {
        return tIndustryMapper.deleteTIndustryById(id);
    }


    /**
     * 查询工业用户入户安检信息
     * @param industry 工业用户信息
     * @return
     */
    @Override
    public List<TIndustry> getIndustryInspectInfo(TIndustry industry){
        return tIndustryMapper.getIndustryInspectInfo(industry);
    }
}
